/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event.http;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;

/**
 * Listener interface for http-file-cache related events.
 */
public interface HSHttpFileCacheEventListener extends AdminEventListener {

    /**
     * Handles the given http-file-cache attribute removal event.
     *
     * @param event Event to be processed.
     *
     * @exception AdminEventListenerException if an error occurs during the
     * processing of the event.
     */
    public void handleDelete(HSHttpFileCacheEvent event)
            throws AdminEventListenerException;

    /**
     * Handles the given http-file-cache attribute modification event.
     *
     * @param event Event to be processed.
     *
     * @exception AdminEventListenerException if an error occurs during the
     * processing of the event.
     */
    public void handleUpdate(HSHttpFileCacheEvent event)
            throws AdminEventListenerException;

    /**
     * Handles the given http-file-cache attribute creation event.
     *
     * @param event Event to be processed.
     *
     * @exception AdminEventListenerException if an error occurs during the
     * processing of the event.
     */
    public void handleCreate(HSHttpFileCacheEvent event)
            throws AdminEventListenerException;

}
