/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.selfmanagement.event;
import javax.management.ObjectName;
import javax.management.NotificationFilter;
import javax.management.MalformedObjectNameException;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;


public class TimerEvent implements Event {
    private static StringManager sm = StringManager.getManager(TimerEvent.class);
    private static Logger _logger=LogDomains.getLogger(LogDomains.SELF_MANAGEMENT_LOGGER);
    TimerEvent(Integer id, NotificationFilter filter, String description) {
        this.id = id;
        this.filter = filter;
        if (description != null)
            this.description = description;
        else
            this.description = defaultDescription;
    }
    public ObjectName getObjectName() {
        return getTimerObjectName();
    }
    public String getType() {
        return "timer";
    }
    public NotificationFilter getNotificationFilter() {
        return filter;
    }
    public String  getDescription() {
        return description;
    }
    public void destroy() {
        TimerEventFactory.getInstance().removeEvent(id);
    }
    static ObjectName getTimerObjectName() {
        if (objName != null)
            return objName;
        try {
            objName = new ObjectName(DOMAIN_NAME, DEFAULT_KEY,"timer");
            return objName;
        } catch (MalformedObjectNameException ex) {
            _logger.log(Level.WARNING,"smgt.internal_error", ex);
        }
        return null;
    }
    
    private static ObjectName objName = null;
    private NotificationFilter filter = null;
    private String description = null;
    private static String defaultDescription = sm.getString("selfmgmt_event.timer_event_description");
    private int id;
}
