/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.server.core.channel;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.ExecException;


/**
 * ReconfigHelper executes reconfig command in a sub-process, which triggers
 * refresh within web container.
 */
public class ReconfigHelper {

    private static boolean reconfigEnabled = false;
    private static Class j2eeRunnerClass = null;
    private static Method reconfigMethod = null;

    static void enableWebCoreReconfig() throws ClassNotFoundException,
            NoSuchMethodException, SecurityException {
        findReconfigMethod();
        if (reconfigMethod != null) {
            reconfigEnabled = true;
        }
    }

    /**
     * Send reconfigure message to specified instance
     */
    public static void sendReconfigMessage(String instanceName) {
/*
        int ret = reconfig(instanceName);
        if (ret != 0) {
            AdminChannel.warn(RECONFIG_ERROR);
        }
*/
        if (reconfigEnabled) {
            try {
                reconfigMethod.invoke( null, (Object[])null);
            } catch (IllegalAccessException access) {
                AdminChannel.warn(RECONFIG_ERROR);
                AdminChannel.debug(access);
            } catch (IllegalArgumentException arg) {
                AdminChannel.warn(RECONFIG_ERROR);
                AdminChannel.debug(arg);
            } catch (InvocationTargetException ite) {
                AdminChannel.warn(RECONFIG_ERROR);
                AdminChannel.debug(ite.getTargetException());
                AdminChannel.debug(ite);
            }
        }
    }

    private static int reconfig(String instanceName) {
        int retval = 0;
        String[] cmd = getReconfigCommand(instanceName);
        if (cmd != null) {
            ProcessExecutor pe = new ProcessExecutor(cmd);
            try {
                pe.execute();
            } catch (ExecException ee) {
                AdminChannel.debug(ee);
                retval = 1;
            }
        }
        return retval;
    }

    private static String[] getReconfigCommand(String instance) {
        String pfx = AdminChannel.instanceRoot + File.separator + instance
                + File.separator;
        if (OS.isUnix()) {
            return new String[]{pfx + "reconfig"};
        } else if (OS.isWindows()) {
            return new String[]{pfx + "reconfig.bat"};
        } else {
            return null;
        }
    }

    private static void findReconfigMethod() throws ClassNotFoundException,
            NoSuchMethodException, SecurityException {
        j2eeRunnerClass = Class.forName(J2EE_RUNNER_CLASS);
        reconfigMethod = j2eeRunnerClass.getMethod(RECONFIG_METHOD, (Class[])null);
    }   

    private final static String J2EE_RUNNER_CLASS =
            "com.sun.enterprise.server.J2EERunner";
    private final static String RECONFIG_METHOD = "requestReconfiguration";
    private final static String RECONFIG_ERROR = "channel.reconfig_error";
}
