/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.jmx;

import javax.management.MBeanServer;
import java.lang.management.ManagementFactory;

/**
 * AppServer's MBS factory to create a singleton MBS
 * (with interceptors) necessary for the appserver.
 *
 * @author  sridatta
 */
public class AppServerMBeanServerFactory {
    
    private static MBeanServer _mbs  = null;
    
    /**
     * Factory method to generate the only instance of this class in the JVM.
     * Makes sure that the constructor of this class is called exactly once.
     *
     * @return MBeanServer instance by calling private constructor.
     * @throws InitException if the MBeanServer can not be initialized.
     */
    public synchronized static MBeanServer getMBeanServerInstance()
    throws InitException {
        if (_mbs == null) {
            _mbs = getAppServerMBeanServer();
            //Also bind in JNDI // TBD FIXME
            // so that it can be used in a generic way
        }
        return ( _mbs );
    }
    
    /**
     * This method gets app server's MBS. First, it
     * enables AppServer MBS on the builder, then creates
     * the MBS using the standard mechanism and then
     * resets the flag. It is synchronized on the builder
     * since we do not want anyone creating an MBS
     * during this period.
     */
    private static MBeanServer getAppServerMBeanServer() {
        MBeanServer ms = null;
        synchronized (AppServerMBeanServerBuilder.class) {
            AppServerMBeanServerBuilder.enableAppServerMBeanServer(true);
            try {
                ms = ManagementFactory.getPlatformMBeanServer();
            } finally {
                AppServerMBeanServerBuilder.enableAppServerMBeanServer(false);
            }
        }
        return ms;
    }
}
