/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * InstanceSyncWithDAS_TlsClientEnvSetter.java
 */

package com.sun.enterprise.admin.server.core.jmx.ssl;
import com.sun.enterprise.admin.jmx.remote.https.SunOneBasicX509TrustManager;
import com.sun.enterprise.admin.server.core.InMemoryX509TrustManager;
import com.sun.enterprise.security.ssl.UnifiedX509TrustManager;
import com.sun.enterprise.util.SystemPropertyConstants;

import java.io.File;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;


/** This class is meant specifically for the setup of client side environment when
 * the Node agent synchronizes an instance with a DAS 
 * @author  Nandini.Ektare@sun.com
 * @since Sun Java System Application Server 8.2ee
 */
public class InstanceSyncWithDAS_TlsClientEnvSetter extends AsTlsClientEnvSetter {
 
    private String mCertNickname;
    
    public InstanceSyncWithDAS_TlsClientEnvSetter() {
        super();
        mCertNickname = System.getProperty(
            SystemPropertyConstants.AGENT_CERT_NICKNAME);
    }

    protected TrustManager[] getTrustManagers() {
        InMemoryX509TrustManager mgr = null;
        try {
            
            String instanceRoot = System.getProperty(
                SystemPropertyConstants.INSTANCE_ROOT_PROPERTY);
            String serverName = System.getProperty(
                SystemPropertyConstants.SERVER_NAME);
            
            System.setProperty(SystemPropertyConstants.INSTANCE_ROOT_PROPERTY, 
                System.getProperty(SystemPropertyConstants.AGENT_ROOT_PROPERTY));
            System.setProperty(SystemPropertyConstants.SERVER_NAME, 
                System.getProperty(SystemPropertyConstants.AGENT_NAME_PROPERTY));
            mgr = new InMemoryX509TrustManager(mCertNickname);

            System.setProperty(SystemPropertyConstants.INSTANCE_ROOT_PROPERTY, instanceRoot);
            System.setProperty(SystemPropertyConstants.SERVER_NAME, serverName);
        } catch (Throwable t) {
            t.printStackTrace();
        }
        
        return new TrustManager[] {mgr};
    }
}