/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * NodeAgentSyncWithDAS_TlsClientEnvSetter.java
 */

package com.sun.enterprise.admin.server.core.jmx.ssl;
import com.sun.enterprise.admin.jmx.remote.https.SunOneBasicX509TrustManager;
import com.sun.enterprise.admin.server.core.InMemoryX509TrustManager;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.security.ssl.UnifiedX509TrustManager;
import com.sun.enterprise.util.SystemPropertyConstants;

import java.io.File;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;


/** 
 * This class is meant specifically for the setup of client side 
 * environment when the Node agent synchronizes with DAS 
 * @author  Nandini.Ektare@sun.com
 * @since Sun Java System Application Server 8.2ee
 */
public class NodeAgentSyncWithDAS_TlsClientEnvSetter 
    extends ServerClientEnvSetter implements IAdminConstants {
 
    public NodeAgentSyncWithDAS_TlsClientEnvSetter(String certNickname) {
        super(certNickname);
    }

    protected TrustManager[] getTrustManagers() {
        // if you find the cert.db in the nodeagent filelayout 
        File dasCertDBFile = new File( System.getProperty(
            SystemPropertyConstants.INSTANCE_ROOT_PROPERTY) +
            "/config/cert8.db");
        if (dasCertDBFile.exists()) {
            return new TrustManager [] {
                new UnifiedX509TrustManager( 
                    new X509TrustManager[] {
                        new InMemoryX509TrustManager(mCertNickName)
                    } 
                ) 
            };
        } else {
            return (new TrustManager[] { new SunOneBasicX509TrustManager()} );
        }
    }
}