/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

//JMX imports
import javax.management.*;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;


//Admin imports
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;

/**
    This Config MBean represents a Ssl element.
    This class is generic base for different Ssl elemenets (from OrbListener or ConnectionGroup)
    It extends ConfigMBeanBase class which provides get/set attribute(s) and getMBeanInfo services according to text descriptions.
*/
public class SslBase extends ConfigMBeanBase implements ConfigAttributeName.Ssl
{
    /**
     * MAPLIST array defines mapping between "external" name and its location in XML relatively base node
     */
    static final String[][] MAPLIST  =
    {
        //----- SSL --------
        {kCertNickname       ,  ATTRIBUTE + ServerTags.CERT_NICKNAME},
        {kSsl2Enabled        ,  ATTRIBUTE + ServerTags.SSL2_ENABLED},
        {kSsl2Ciphers        ,  ATTRIBUTE + ServerTags.SSL2_CIPHERS},
        {kSsl3Enabled        ,  ATTRIBUTE + ServerTags.SSL3_ENABLED},
        {kSsl3TlsCiphers     ,  ATTRIBUTE + ServerTags.SSL3_TLS_CIPHERS},
        {kTlsEnabled         ,  ATTRIBUTE + ServerTags.TLS_ENABLED},
        {kTlsRollbackEnabled ,  ATTRIBUTE + ServerTags.TLS_ROLLBACK_ENABLED},
        {kClientAuthEnabled  ,  ATTRIBUTE + ServerTags.CLIENT_AUTH_ENABLED},
    };
    /** 
     * ATTRIBUTES array specifies attributes descriptions in format defined for MBeanEasyConfig
     */
    static final String[]   ATTRIBUTES  =
    {
        kCertNickname       +", String,  RW" ,
        kSsl2Enabled        +", Boolean, RW" ,
        kSsl2Ciphers        +", String,  RW" ,
        kSsl3Enabled        +", Boolean, RW" ,
        kSsl3TlsCiphers     +", String,  RW" ,
        kTlsEnabled         +", Boolean, RW" ,
        kTlsRollbackEnabled +", Boolean, RW" ,
        kClientAuthEnabled  +", Boolean, RW" ,
    };
    /** 
     * OPERATIONS array specifies operations descriptions in format defined for MBeanEasyConfig
     */
    private static final String[]   OPERATIONS  = null;
    
    /**
        Default constructor sets MBean description tables
    */
    public SslBase() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

}