/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.Validator;

// JDK includes
import java.io.Serializable;


/**
    Optional base class for all implementations of IValidator.
 */
public class BaseValidator implements Validator, Serializable
{
    private final static String         kMustBeNonNull  = 
                                                    "object must be non-null";

    private static final BaseValidator  sInstance       = new BaseValidator();
	
    /**
        Validate the object by checking for non-null.  It is expected
        that subclasses will override this behavior but may invoke
        super.validate() to make this check.

        @param object	the object to validate (check for non-null)
        @returns a ValidatorResult indicating the validity
     */
    public ValidatorResult validate( Object object )
    {
            ValidatorResult	result	= ValidatorResult.kValid;

            if ( object == null )
            {
                result	= new ValidatorResult( false, kMustBeNonNull );
            }

            return( result );
    }
	
    /**
        A convenience for any client that needs the default object Validator
        (which never changes).  It could be used, for example, to invoke
        getInstance().validate( object ).
     */
    public static Validator getInstance()
    {
        return( sInstance );
    }
}