/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.util;

import java.util.regex.Pattern;
import java.util.regex.Matcher;

// i18n import 
import com.sun.enterprise.admin.util.SOMLocalStringsManager;

public class RegExpMatcher implements IPatternMatcher
{
	private		String  mPatternString	= null;
	private		String	mTestString		= null;

	// i18n SOMLocalStringsManager
	private static SOMLocalStringsManager localizedStrMgr =
		SOMLocalStringsManager.getManager( RegExpMatcher.class );

	/** 
		Creates new RegExpMatcher.
	*/
	
	public RegExpMatcher(String patternString, String testString)
	{
        if (patternString == null || testString == null)
        {
			String msg = localizedStrMgr.getString( "admin.util.regexpmatcher_null_arg" );
            throw new IllegalArgumentException( msg );
        }
		mPatternString	= patternString;
		mTestString		= testString;
    }

	public boolean matches()
	{
		Pattern strPattern	= Pattern.compile(mPatternString);
		Matcher matcher		= strPattern.matcher(mTestString);
		
		return ( matcher.matches() );
	}	
}
