/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ServerXmlTest.java
 *
  */

package com.sun.enterprise.admin.verifier;

//import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.admin.util.LocalStringsManager;
import com.sun.enterprise.tools.verifier.*;

// Logging
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;



/**
 * ServerXmlTest which is the superclass of all TestCases returns Results Object with Result Class Set
 * 
 */

public class ServerXmlTest {
    
    // Logging
    static Logger _logger = LogDomains.getLogger(LogDomains.APPVERIFY_LOGGER);
    
    public com.sun.enterprise.util.LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    public boolean debug = false;
    
    /** Creates a new instance of ServerXmlTest */
    public ServerXmlTest() {
        // set the local strings manager
        try {
            //StringManagerHelper.setLocalStringsManager(Class.forName(getClass().getName()));
            StringManagerHelper.setLocalStringsManager(Class.forName("com.sun.enterprise.admin.verifier.ServerXmlTest"));
            smh = StringManagerHelper.getLocalStringsManager();
        }
        catch (ClassNotFoundException e) {
            // Logging
            _logger.log(Level.FINE, "serverxmlverifier.class_notfound_exception", e);
        }

    }
    
    protected Result getInitializedResult() {
        if (debug) {
            // Logging
            _logger.log(Level.INFO, 
            "\n********************************************************** \n " +
            smh.getLocalString("which.class.called.string", getClass() + " called \n",
            new Object[] {getClass()}) +
            "\n**********************************************************");
            
        }

        Result result = new Result();
        result.init(getClass());
        if (debug) {
                // Logging
                _logger.log(Level.INFO, 
                smh.getLocalString
                ("test.string" + ".assertion",
                "Assertion from resource file is: [ {0} ]",
                new Object[] {result.getAssertion()}));
        }
        return result;
    }
        
}
