/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.connectors.authentication;

import java.io.Serializable;
import com.sun.enterprise.connectors.authentication.EisBackendPrincipal;

/**
 * @author ko133006
 */
public class ConnectorSecurityMap implements Serializable {
    private String name;

    private String[] principals;

    private String[] userGroups;

    private EisBackendPrincipal backendPrincipal;

    public ConnectorSecurityMap(String name, String[] principals,
            String[] userGroups, EisBackendPrincipal backendPrincipal) {
        this.name = name;
        this.principals = principals;
        this.userGroups = userGroups;
        this.backendPrincipal = backendPrincipal;
    }

    /**
     * @return Returns the backendPrincipal.
     */
    public EisBackendPrincipal getBackendPrincipal() {
        return this.backendPrincipal;
    }

    /**
     * @param backendPrincipal
     *            The backendPrincipal to set.
     */
    public void setBackendPrincipal(EisBackendPrincipal backendPrincipal) {
        this.backendPrincipal = backendPrincipal;
    }

    /**
     * @return Returns the name.
     */
    public String getName() {
        return this.name;
    }

    /**
     * @param name
     *            The name to set.
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * @return Returns the principals.
     */
    public String[] getPrincipals() {
        return this.principals;
    }

    /**
     * @param principals
     *            The principals to set.
     */
    public void setPrincipals(String[] principals) {
        this.principals = principals;
    }

    /**
     * @return Returns the userGroups.
     */
    public String[] getUserGroups() {
        return this.userGroups;
    }

    /**
     * @param userGroups The userGroups to set.
     */
    public void setUserGroups(String[] userGroups) {
        this.userGroups = userGroups;
    }
}
