
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.authentication;

import java.io.Serializable;

/**
 * This a javabean class thatabstracts the backend principal.
 * The backend principal consist of the userName and password
 * which is used for authenticating/getting connection from
 * the backend.
 * @author Srikanth P
 */

public class EisBackendPrincipal implements Serializable{


    private String userName;
    private String password;

    /** Default constructor
     */

    public EisBackendPrincipal() {

    }

    /** 
     * Constructor
     * @param userName UserName
     * @param password Password
     * @credential Credential
     */

    public EisBackendPrincipal(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    /** 
     * Setter method for UserName property
     * @param userName  UserName
     */

    public void setUserName(String userName) {
        this.userName = userName;
    }

    /** 
     * Setter method for password property
     * @param password  Password
     */

    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * Getter method for UserName property
     * @return UserName
     */

    public String getUserName() {
        return userName;
    }

    /**
     * Getter method for Password property
     * @return Password
     */

    public String getPassword() {
        return password;
    }

    /** 
     * Overloaded method from "Object" class
     * Checks the equality.
     * @param backendPrincipal Backend principal against which equality has to
     *        be tested.
     * @return true if they are equal
     *         false if hey are not equal.
     */

    public boolean equals(Object backendPrincipal) {

        if(backendPrincipal == null || 
                 !(backendPrincipal instanceof EisBackendPrincipal)) {
            return false;
        }
        EisBackendPrincipal eisBackendPrincipal = 
                           (EisBackendPrincipal)backendPrincipal;
        
        if(isEqual(eisBackendPrincipal.userName,this.userName) &&
                isEqual(eisBackendPrincipal.password,this.password)) {
            return true;
        } else {
            return false;

        }
    }

    /** Checks whether two strings are equal including the null string
     *  cases.
     */

    private boolean isEqual(String in, String out) {
        if(in == null && out == null) {
            return true;
        }
        if(in == null || out == null) {
            return false;
        }
        return (out.equals(in));
    }
    
    /** 
     * Overloaded method from "Object" class
     * Generates the hashcode
     * 
     * @return a hash code value for this object
     */
    public int hashCode() {
        int result = 67;
        if(userName != null)
            result = 67 * result + userName.hashCode();
        if(password != null)
            result = 67*result + password.hashCode();
        return result;
    }
}
