/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.util;

import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.*;
import com.sun.enterprise.server.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.server.*;
import com.sun.enterprise.connectors.*;
import com.sun.enterprise.connectors.system.*;
import com.sun.enterprise.connectors.inflow.*;
import com.sun.enterprise.util.zip.*;
import com.sun.logging.LogDomains;
import java.io.*;
import java.util.logging.*;
import java.util.jar.*;

/**
 * 
 * @author	
 */
public class JmsRaUtil {

    private final String MQ_RAR = "imqjmsra.rar";

    private final String SYSTEM_APP_DIR = 
        "lib" + File.separator + "install" + File.separator + "applications"; 

    private final String MQ_RAR_MANIFEST = 
        ConnectorConstants.DEFAULT_JMS_ADAPTER + File.separator + "META-INF" 
        + File.separator + "MANIFEST.MF";

    // Manifest version tag.
    private final String MANIFEST_TAG = "Implementation-Version";

    private static final String propName_reconnect_delay_in_seconds =
        "reconnect-delay-in-seconds";
    private static final String propName_reconnect_max_retries =
        "reconnect-max-retries";
    private static final String propName_reconnect_enabled =
        "reconnect-enabled";
    private static final int DEFAULT_RECONNECT_DELAY = 60;
    private static final int DEFAULT_RECONNECT_RETRIES = 60;

    private static final String propName_cmt_max_runtime_exceptions 
        = "cmt-max-runtime-exceptions";
    private static final int DEFAULT_CMT_MAX_RUNTIME_EXCEPTIONS = 1;

    private int cmtMaxRuntimeExceptions = DEFAULT_CMT_MAX_RUNTIME_EXCEPTIONS;

    private int reconnectDelayInSeconds = DEFAULT_RECONNECT_DELAY;
    private int reconnectMaxRetries = DEFAULT_RECONNECT_RETRIES;
    private boolean reconnectEnabled = false;

    ServerContext sc = null;
    ConfigContext ctx = null;
    JmsService js = null;
    MQAddressList list = null;

    static Logger _mdblogger = LogDomains.getLogger(LogDomains.MDB_LOGGER);
    static Logger _rarlogger = LogDomains.getLogger(LogDomains.RSR_LOGGER);

    public JmsRaUtil() throws ConnectorRuntimeException {
        this(null);
    }

    public JmsRaUtil(JmsService js) throws ConnectorRuntimeException {
        try {
            if (js != null) {
	        this.js = js;
            } else {
	        sc = ApplicationServer.getServerContext();
	        ctx = sc.getConfigContext();
	        this.js = ServerBeansFactory.getJmsServiceBean(ctx);
            }
            list = new MQAddressList(this.js);
//            if (isClustered() && ! this.js.getType().equals(
//                ActiveJmsResourceAdapter.REMOTE)) {
//                list.setupForLocalCluster();
//            } else {
                list.setup();
//            }
        } catch(ConfigException ce) {
            throw handleException(ce);
        }
    }

    public String getUrl() {
	try {	
            return list.toString();
	} catch (Exception e) {
	    return null;
	}
    }
    
    public static boolean isClustered() throws ConnectorRuntimeException {
        try {
              ConfigContext ctxt = ApplicationServer.getServerContext().getConfigContext();
              return ServerHelper.isServerClustered(ctxt,
                              ApplicationServer.getServerContext().getInstanceName());
          } catch (ConfigException e) {
              throw handleException(e);
          }
     }

    public String getJMSServiceType(){
 	return this.js.getType();
    }

    public MQAddressList getUrlList() {
        return list;
    }

    public boolean getReconnectEnabled() {
        return js.isReconnectEnabled();
    }

    public String getReconnectInterval() {
        return js.getReconnectIntervalInSeconds();
    }

    public String getReconnectAttempts() { 
        return js.getReconnectAttempts();
    }

    public String getAddressListIterations() {
        return js.getAddresslistIterations();
    }

    public String getAddressListBehaviour() {
        return js.getAddresslistBehavior();
    }

    public void setMdbContainerProperties(){
        com.sun.enterprise.config.serverbeans.MdbContainer mdbc = null;
        try {
            com.sun.enterprise.server.ServerContext sc =
                com.sun.enterprise.server.ApplicationServer.getServerContext();

            mdbc = com.sun.enterprise.config.serverbeans.ServerBeansFactory.
                  getMdbContainerBean(sc.getConfigContext());

        } 
        catch (Exception e) {
            _mdblogger.log(Level.WARNING, "containers.mdb.config_exception", 
                        new Object[]{e.getMessage()});
            if (_mdblogger.isLoggable(Level.FINE)) {
                _mdblogger.log(Level.FINE, e.getClass().getName(), e);
            }
        }

        if (mdbc != null) {
            ElementProperty[] props = mdbc.getElementProperty();
            if (props != null) {
                for (int i = 0; i < props.length; i++) {
                    ElementProperty p = props[i];
                    if (p == null) continue;
                    String name = p.getName();
                    if (name == null) continue;
                    try {
                        if (name.equals(propName_reconnect_enabled)) {
                            if (p.getValue() == null) continue;
                            reconnectEnabled = 
                                Boolean.valueOf(p.getValue()).booleanValue();
                        }
                        else if (name.equals
                                 (propName_reconnect_delay_in_seconds)) {
                            try {
                                reconnectDelayInSeconds = 
                                    Integer.parseInt(p.getValue());
                            } catch (Exception e) {
                                _mdblogger.log(Level.WARNING, 
                                    "containers.mdb.config_exception",
                                    new Object[]{e.getMessage()});
                            }
                        }
                        else if (name.equals(propName_reconnect_max_retries)) {
                            try {
                                reconnectMaxRetries = 
                                    Integer.parseInt(p.getValue());
                            } catch (Exception e) {
                                _mdblogger.log(Level.WARNING, 
                                    "containers.mdb.config_exception",
                                    new Object[]{e.getMessage()});
                            }
                        }
                        else if (name.equals
                                 (propName_cmt_max_runtime_exceptions)) {
                            try {
                                cmtMaxRuntimeExceptions = 
                                    Integer.parseInt(p.getValue());
                            } catch (Exception e) {
                                _mdblogger.log(Level.WARNING,
                                    "containers.mdb.config_exception",
                                    new Object[]{e.getMessage()});
                            }
                        }
                    } catch (Exception e) {
                        _mdblogger.log(Level.WARNING, 
                                    "containers.mdb.config_exception", 
                                    new Object[]{e.getMessage()});
                        if (_mdblogger.isLoggable(Level.FINE)) {
                            _mdblogger.log(Level.FINE, e.getClass().getName(), e);
                        }
                    }
                }
            }
        }
        if (reconnectDelayInSeconds < 0) {
            reconnectDelayInSeconds = DEFAULT_RECONNECT_DELAY;
        }
        if (reconnectMaxRetries < 0) {
            reconnectMaxRetries = DEFAULT_RECONNECT_RETRIES;
        }
        if (_mdblogger.isLoggable(Level.FINE)) {
            _mdblogger.log(Level.FINE, 
                propName_reconnect_delay_in_seconds+"="+
                reconnectDelayInSeconds +", "+
                propName_reconnect_max_retries+ "="+reconnectMaxRetries + ", "+
                propName_reconnect_enabled+"="+reconnectEnabled);
        }

        //Now set all these properties in the active resource adapter
        MdbContainerProps.setReconnectDelay(reconnectDelayInSeconds);
        MdbContainerProps.setReconnectMaxRetries(reconnectMaxRetries);
        MdbContainerProps.setReconnectEnabled(reconnectEnabled);
        MdbContainerProps.setMaxRuntimeExceptions(cmtMaxRuntimeExceptions);

    }

    public void configureDescriptor(ConnectorDescriptor cd) {

        Object[] envProps = cd.getConfigProperties().toArray();
	
        for (int i = 0; i < envProps.length; i++) {
            EnvironmentProperty envProp = (EnvironmentProperty) envProps[i];
            String name = envProp.getName();
	    if (!name.equals("ConnectionURL")) {
	        continue;
	    }
            String userValue = getUrl();
            if (userValue != null) {
                cd.removeConfigProperty(envProp);
                cd.addConfigProperty(new EnvironmentProperty(
                              name, userValue, userValue, envProp.getType()));
            }

        }

    }

    /**
     * Obtains the Implementation-Version from the MQ Client libraries
     * that are deployed in the application server and in MQ installation
     * directory.
     */
    public void upgradeIfNecessary() {

        String installedMqVersion = null;
        String deployedMqVersion = null;

        try {
           installedMqVersion = getInstalledMqVersion();
           _rarlogger.log(Level.FINE,"installedMQVersion :: " + installedMqVersion);
           deployedMqVersion =  getDeployedMqVersion();
           _rarlogger.log(Level.FINE,"deployedMQVersion :: " + deployedMqVersion);
        }catch (Exception e) {
	    return;
        }

        String deployed_dir = 
           java.lang. System.getProperty(Constants.INSTALL_ROOT) 
           + File.separator + SYSTEM_APP_DIR + File.separator 
           + ConnectorConstants.DEFAULT_JMS_ADAPTER;

        // If the Manifest entry has different versions, then attempt to 
        // explode the MQ resource adapter.
        if (!installedMqVersion.equals(deployedMqVersion)) {
           try {
               _rarlogger.log(Level.INFO, "jmsra.upgrade_started" );
	       ZipFile rarFile = new ZipFile(java.lang.System.getProperty
                                 (Constants.INSTALL_IMQ_LIB) + 
                                 File.separator + MQ_RAR, deployed_dir);
               rarFile.explode();
               _rarlogger.log(Level.INFO, "jmsra.upgrade_completed");
	   } catch(ZipFileException ze) {
               _rarlogger.log(Level.SEVERE,"jmsra.upgrade_failed",ze.getMessage());
           }
        }

    }

    private String getInstalledMqVersion() throws Exception {
       String ver = null;
       // Full path of installed Mq Client library
       String installed_dir = 
           java.lang.System.getProperty(Constants.INSTALL_IMQ_LIB);
       String jarFile = installed_dir + File.separator + MQ_RAR;
       _rarlogger.log(Level.FINE,"Installed MQ JAR " + jarFile);

       try {
           JarFile jFile = new JarFile(jarFile);
           Manifest mf = jFile.getManifest();
           ver = mf.getMainAttributes().getValue(MANIFEST_TAG);
           return ver;
       } catch (Exception e) {
           _rarlogger.log(Level.WARNING, "jmsra.upgrade_check_failed", 
                       e.getMessage() + ":" + jarFile );
           throw e;
       }
    }

    private String getDeployedMqVersion() throws Exception {
       String ver = null;
        // Full path of Mq client library that is deployed in appserver.
       String deployed_dir = 
           java.lang.System.getProperty(Constants.INSTALL_ROOT) 
           + File.separator + SYSTEM_APP_DIR; 
       String manifestFile = deployed_dir + File.separator +
                             MQ_RAR_MANIFEST; 
       _rarlogger.log(Level.FINE,"Deployed MQ version Manifest file" + manifestFile);
       try {
           Manifest mf = new Manifest(new FileInputStream(manifestFile));
           ver = mf.getMainAttributes().getValue(MANIFEST_TAG);
           return ver;
       } catch (Exception e) {
           _rarlogger.log(Level.WARNING, "jmsra.upgrade_check_failed", 
                       e.getMessage() + ":" + manifestFile );
           throw e;
       }
   }

   private static ConnectorRuntimeException handleException(Exception e) {
        ConnectorRuntimeException cre =
             new ConnectorRuntimeException(e.getMessage());
        cre.initCause(e);
        return cre;
    }
}
