/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.work;

import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkListener;
import java.util.logging.*;
import com.sun.logging.LogDomains;

/**
 * Represents one piece of work that will be submitted to the workqueue.
 *
 * @author Binod P.G	
 */
public final class OneWork implements com.sun.corba.ee.spi.orbutil.threadpool.Work {

    private final Work work;
    private final WorkCoordinator coordinator;
    private long nqTime;
    private static final Logger logger =
        LogDomains.getLogger(LogDomains.RSR_LOGGER);

    /**
     * Creates a work object that can be submitted to a workqueue.
     *
     * @param work Actual work submitted by Resource adapter.
     * @param coordinator <code>WorkCoordinator</code> object.
     */
    OneWork (Work work, WorkCoordinator coordinator) {
        this.work = work;
        this.coordinator = coordinator;
    }
    
    /**
     * This method is executed by thread pool as the basic work operation.
     */
    public void doWork() {
        coordinator.preInvoke();
        if (coordinator.proceed()) {
            try {
                work.run();
            } catch (Throwable t) {
                coordinator.setException(t);
            }
        }
        coordinator.postInvoke();
    }
    
    /**
     * Time at which this work is enqueued.
     *
     * @param tme Time in milliseconds.
     */
    public void setEnqueueTime(long tme) {
        this.nqTime = tme;
    }

    /**
     * Retrieves the time at which this work is enqueued
     *
     * @return Time in milliseconds.
     */
    public long getEnqueueTime() {
        return nqTime;
    }

    /**
     * Retrieves the name of the work.
     *
     * @return Name of the work.
     */
    public String getName() {
        return "Resource adapter work";
    }

    /**
     * Retrieves the string representation of work.
     *
     * @return String representation of work.
     */
    public String toString () {
        return (work.toString());
    }
}
