/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/* 
 * DeploymentLogger.java
 *
 * Created on April 25, 2002, 5:55 PM
 * 
 * @author  bnevins
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/backend/DeploymentLogger.java,v $
 *
 */

package com.sun.enterprise.deployment.backend;

import com.sun.logging.LogDomains;
import java.util.logging.*;

// Resource Bundle:
// com/sun/logging/enterprise/system/tools/deployment/backend/LogStrings.properties

public final class DeploymentLogger
{
	public final static Logger get()
	{
		// the final should cause this to be inlined...
		return logger;
	}
	
	///////////////////////////////////////////////////////////////////////////

	private DeploymentLogger() 
	{
	}

	///////////////////////////////////////////////////////////////////////////
		
		
	private static final Logger	logger;

	static
	{
        Logger tempLogger = null;
		try
		{
			tempLogger = LogDomains.getLogger(LogDomains.DPL_LOGGER);
			tempLogger.finest("Successfully created Deployment Logger");
		}
		catch(Throwable t)
		{
			try
			{
				tempLogger = LogDomains.getLogger(LogDomains.ROOT_LOGGER);
				tempLogger.warning("Couldn't create Deployment Logger -- created a Root Logger instead");
			}
			catch(Throwable t2)
			{
				// now what?
			}
		}
        finally
        {
            logger = tempLogger;
        }
	}
	public static void main(String[] args)
	{
		logger.setLevel(Level.FINEST);
	    logger.info("dadads");
		logger.log(Level.INFO, "info", new String[] {"Yo", "ewe" });
		logger.log(Level.FINE, "fine", new String[] {"Yo", "ewe" });
	}
}
/*
 java.util.MissingResourceException: Can't find 
com.sun.logging.enterprise.system.tools.deployment.backend.LogStrings bundl
e
 */

