/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentPhaseException.java
 *
 * Created on June 4, 2003, 3:18 PM
 * @author  sandhyae
 * <BR> <I>$Source: /cvs/glassfish/appserv-core/src/java/com/sun/enterprise/deployment/phasing/DeploymentPhaseException.java,v $
 *
 */

package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.backend.IASDeploymentException;

/**
 * Represents exceptions coming from different deployment phases
 * @author  Sandhya E
 */
public final class DeploymentPhaseException extends IASDeploymentException {
    

    /**
     * Creates a new instance of <code>DeploymentPhaseException</code> without detail message.
     */
    public DeploymentPhaseException(String phaseName, String msg, Throwable t) {
        super(msg, t);
        this.phaseName = phaseName;
    }
    
    public DeploymentPhaseException(String phaseName, String msg) {
        super(msg);
        this.phaseName = phaseName;
    }
        
    /**
     * Returns the phasename
     * @return phaseName name of the phase from where exception is happening
     */
    public String getPhaseName() {
        return phaseName;
    }
    
    /**
     * Returns the level of this exception
     * @return level exception level [FATAL/NON_FATAL]
     */
    public int getLevel() {
        return level;
    }
    
    /**
     * Sets the error level of this exception
     * @param level error level [FATAL/NON_FATAL]
     */
    public void setLevel(int level) {
        this.level = level;
    }
    
    private final String phaseName;
    private int level = FATAL;
    
    public static final int FATAL = 0;
    public static final int NON_FATAL = 1;
}
