/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.collect;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

import com.sun.enterprise.diagnostics.Data;

/**
 * 
 * @author Manisha Umbarje
 */
public class WritableDataImpl implements WritableData {
    
    protected List<Data> children;
    
    protected List<String> values;
    
    protected List<List<String>> table;
    
    protected String source;
    protected String type;
    
    private static int INITIAL_CAPACITY = 5;
    
    public WritableDataImpl() {
        this("", DataType.CONTAINER);
    }
    public WritableDataImpl(String type) {
        this("",type);
    }
    /** Creates a new instance of WritableDataImpl */
    public WritableDataImpl(String source, String type) {
        this(source,type, 5,20);
    }
    
    public WritableDataImpl(String source, String type,
            int initialValuesCapacity) {
        this(source, type, INITIAL_CAPACITY, initialValuesCapacity);
        
    }
    public WritableDataImpl(String source, String type,
        int initialChildrenCapacity, int initialValuesCapacity) {
        this(source,type, initialChildrenCapacity,
                initialValuesCapacity,INITIAL_CAPACITY);
        
    }
    public WritableDataImpl(String source, String type, 
            int initialChildrenCapacity, 
        int initialValuesCapacity, int initialTableCapacity) {
        
        this.source= source;
        this.type = type;
        children = new ArrayList(initialChildrenCapacity);
        values = new ArrayList(initialValuesCapacity);
        table = new ArrayList(initialTableCapacity);
        
    }
    
    public void addChild(Data dataObj) {
        if(dataObj != null)
            children.add(dataObj);
    }
    
    public void addValue(String value) {
        values.add(value);
    }
    
    public void addRow(List<String> list) {
        if(list != null)
            table.add(list);
    }
    public Iterator<Data> getChildren() {
        return children.iterator();
    }
    
    
    public Iterator<String> getValues() {
        return values.iterator();
    }
    public Iterator<Iterator<String>> getTable() {
        List<Iterator<String>> listOfIterators = new ArrayList();
        Iterator<List<String>> iterator = table.iterator();
        while(iterator.hasNext()) {
            List row = iterator.next();
            listOfIterators.add(row.iterator());
        }
        return listOfIterators.iterator();
    }
    public String getSource() {
        return source;
    }
    public String getType() {
        return type;
    }
}
