/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

/**
 * Represents a cascaded stylesheet.
 * @author Jagadish
 */
public class CSS extends HTMLElement {
    private static String LINK = "LINK";
    private static String REL = "rel";
    private static String STYLESHEET = "stylesheet";
    private static String HREF = "href";
    private static String TYPE = "type";
    private static String TEXT_CSS="text/css";
    private static String STYLE = "style";
    private static String COMMENT_START="<!--";
    private static String COMMENT_END="-->";
    
    /** Creates a new instance of CSS */
    public CSS(String link, Document doc) {
        super(LINK);
        addAttribute(REL,STYLESHEET);
        addAttribute(HREF,link);
        addAttribute(TYPE, TEXT_CSS);

        Element head = doc.getHead();
        head.add(this);
    }
    
    public CSS(StringBuffer text, Document doc)    {
        super(STYLE);
        addAttribute(TYPE, TEXT_CSS);
        addText(COMMENT_START + text.toString() + COMMENT_END);
        
        Element head = doc.getHead();
        head.add(this);
    }
    
}
