/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop;

import java.util.logging.*;

import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.INTERNAL;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;


import com.sun.logging.*;

public class SFSBVersionIORInterceptor
    extends org.omg.CORBA.LocalObject
    implements org.omg.PortableInterceptor.IORInterceptor {

    private static final Logger _logger =
        LogDomains.getLogger(LogDomains.EJB_LOGGER);
    
    private Codec codec;

    public SFSBVersionIORInterceptor(Codec c) {
        codec = c;
    }

    public void destroy() {
    }

    public String name() {
        return "SFSBVersionIORInterceptor";
    }

    // Note: this is called for all remote refs created from this ORB,
    // including EJBs and COSNaming objects.
    public void establish_components(IORInfo iorInfo) {
        try {
            _logger.log(Level.FINE,
                    "SFSBVersionIORInterceptor.establish_components->:");

            // Add OTS tagged components. These are always the same for all EJBs
            SFSBVersionPolicy versionPolicy = null;
            try {
                versionPolicy = (SFSBVersionPolicy) iorInfo
                        .get_effective_policy(POARemoteReferenceFactory.SFSB_VERSION_POLICY_TYPE);
            } catch (INV_POLICY ex) {
                _logger.log(Level.FINE,
                        "SFSBVersionIORInterceptor.establish_components: SFSB_VERSION_POLICY_TYPE not present", ex);
            }
            if (versionPolicy != null) {
                addSFSBVersionComponents(iorInfo);
            }

        } catch (Exception e) {
            _logger.log(Level.WARNING, "Exception in establish_components", e);
        } finally {
            _logger.log(Level.FINE,
                    "SFSBVersionIORInterceptor.establish_components<-:");
        }
    }

    private void addSFSBVersionComponents(IORInfo iorInfo) {
        long versionNumber = 0;

        Any versionAny = ORB.init().create_any();

        versionAny.insert_longlong(versionNumber);

        byte[] versionValue = null;
        try {
            versionValue = codec.encode_value(versionAny);
        } catch (org.omg.IOP.CodecPackage.InvalidTypeForEncoding e) {
            INTERNAL ex = new INTERNAL("InvalidTypeForEncoding " + e.getMessage());
            ex.initCause(e);
            throw ex;
        }

        TaggedComponent sfsbVersionComponent = new TaggedComponent(
                POARemoteReferenceFactory.SFSB_VERSION_POLICY_TYPE,
                versionValue);
        iorInfo.add_ior_component(sfsbVersionComponent);
        _logger.log(Level.FINE,
                "SFSBVersionIORInterceptor.addSFSBVersionComponents added...");
    }

}

// End of file.
