/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.instance;

import java.util.Map;
import java.util.HashMap;

import com.sun.enterprise.config.ConfigContext;
import  com.sun.enterprise.deployment.backend.DeployableObjectInfo;
import  com.sun.enterprise.deployment.backend.DeployableObjectType;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.ConfigException;

import com.sun.enterprise.config.serverbeans.PropertyResolver;

/** Base-class for all the different types of ModulesManager's.
 *  Put common code that applies to all types of modules in here...
 **/

public abstract class ModulesManager extends BaseManager {
    protected ModulesManager(InstanceEnvironment env, boolean useBackupServerXml) throws ConfigException {
        super(env, useBackupServerXml);
    }
    
    /**
     * @return the registered descriptors map
     */
    public Map getRegisteredDescriptors() {
                
        if (modules==null) {
            synchronized (ModulesManager.class) {
                if (modules==null) {
                    modules = new HashMap();
                }
            }
        } 
        return modules;
    }
    
    protected String resolvePath(String path) {
        String resolved = path;
        try {
            resolved =  new PropertyResolver(configContext, 
                getInstanceEnvironment().getName()).resolve(path);
        } catch (ConfigException ce) {
            //log this.
        }
        return resolved;
    }

    private static Map modules = null;
    
}
