/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;

import java.util.*;

/**
 * This is a registry class that keep the recoveryresource listeners.
 * A lifecycle module will be able to use this singleton to register
 * its recoveryresourcelisteners.
 *
 * @author Binod PG
 * @since 9.1
 */
public class RecoveryResourceRegistry  {

    private static RecoveryResourceRegistry rrr = null;
    private Set listeners = null;
    
    private RecoveryResourceRegistry() {
        listeners = new HashSet();
    }

    public static RecoveryResourceRegistry getInstance() {
        if (rrr == null) {
            rrr = new RecoveryResourceRegistry();
        }
        return rrr;
    }

    public void addListener(RecoveryResourceListener rrl) {
        listeners.add(rrl);
    }

    public Set getListeners() {
        return listeners;
    }
    
}
