/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.resource;

import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.logging.LogDomains;

import java.util.logging.*;

/**
  * @author    Srikanth P
  */

public class ResourceAdapterConfigDeployer implements ResourceDeployer {

    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);
    public synchronized void deployResource(Object resource) throws Exception {

        ResourceAdapterConfig domainConfig = 
            (com.sun.enterprise.config.serverbeans.ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        _logger.log(Level.FINE,
                   "Calling backend to add resource adapterConfig ",rarName);
        crt.addResourceAdapterConfig(rarName,domainConfig);
        _logger.log(Level.FINE,
                   "Added resource adapterConfig in backend",rarName);
    }

    public synchronized void undeployResource(Object resource) 
                  throws Exception {
        ResourceAdapterConfig domainConfig = 
            (com.sun.enterprise.config.serverbeans.ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        crt.deleteResourceAdapterConfig(rarName);
    }

    public synchronized void redeployResource(Object resource) 
                  throws Exception {
        deployResource(resource);
    }

    public synchronized void disableResource(Object resource) 
                  throws Exception {

    }

    public synchronized void enableResource(Object resource) throws Exception {
    }

    public Object getResource(String name, Resources rbeans)
               throws Exception {

        Object res = rbeans.getResourceAdapterConfigByResourceAdapterName(name);
        if (res == null) {
            Exception ex = new Exception("No such resource");
            _logger.log(Level.SEVERE,"no_resource",name);
            _logger.log(Level.SEVERE,"",ex);
            throw ex;
        }
        return res;
    }

}
