/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;

import javax.transaction.Transaction;

/**
 * Interface definition for the Resource Manager. Depending on the
 * ResourceSpec, PoolManager selects appropriate Resource Manager.
 *
 * @author Binod PG
 */ 
public interface ResourceManager {

    /**
     * Returns the current Transaction, resource should be dealing with.
     *
     * @return An instance of Transaction object.
     * @exception PoolingException If there is any error in getting the 
     * 		  transaction
     */
    public Transaction getTransaction() throws PoolingException;

    /**
     * Get the component involved in invocation. Returns null , if there is
     * no component is involved in the current invocation. 
     * 
     * @return object handle
     */
    public Object getComponent() ;
    
    /**
     * Enlist the Resource handle to the transaction.
     * 
     * @param h Resource to be enlisted.
     * @exception PoolingException If there is any error in enlisting.
     */
    public void enlistResource(ResourceHandle h) throws PoolingException;

    /**
     * Register the resource for a transaction's house keeping activities.
     *
     * @param h Resource to be registered.
     * @exception PoolingException If there is any error in registering.     
     */
    public void registerResource(ResourceHandle handle) throws PoolingException;
    
    /**
     * Set the transaction for rolling back.
     */
    public void rollBackTransaction();
    
    /**
     * Delist the resource from the transaction.
     *
     * @param h Resource to be delisted.
     */
    public void delistResource(ResourceHandle resource, int xaresFlag);
    
    /**
     * Unregister the resource from a transaction's list.
     *
     * @param h Resource to be unregistered.     
     */
    public void unregisterResource(ResourceHandle resource, int xaresFlag);
}
