/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;


import com.sun.enterprise.Switch;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.enterprise.connectors.ConnectorConstants.PoolType;

/**
 * @author Aditya Gore
 */
public class ResourcePoolFactoryImpl {

    private static Logger _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);
    
    //property to take care of switching off connection pooling in ACC
    //since 9.1
    private static final String SWITCH_OFF_ACC_CONNECTION_POOLING =
 	"com.sun.enterprise.connectors.SwitchoffACCConnectionPooling";
    private static String switchOffACCConnectionPoolingProperty = 
            System.getProperty(SWITCH_OFF_ACC_CONNECTION_POOLING);
    
    
    public static ResourcePool newInstance( String poolName, PoolType pt ) 
        throws PoolingException {
        ResourcePool pool = null;
        
        if(Switch.getSwitch().getContainerType() == Switch.APPCLIENT_CONTAINER){
            if("TRUE".equalsIgnoreCase(switchOffACCConnectionPoolingProperty))
                return new UnpooledResource( poolName );
        }

        if ( pt == PoolType.ASSOCIATE_WITH_THREAD_POOL ) {
            pool = new AssocWithThreadResourcePool( poolName );
        } else {
            pool = new SJSASResourcePool( poolName );
        }

        if( _logger.isLoggable( Level.FINE ) ) {
            _logger.fine( "Using Pool " + pt);
        }

        return pool; 
    }
}
