/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource.monitor;

//removed unnecessary imports
import java.util.logging.Logger;

import javax.management.j2ee.statistics.Stats;

import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.connectors.work.monitor.ConnectorWorkMonitoringLevelListener;
import com.sun.logging.LogDomains;


/**
 * Provides an implementation of the MonitoringLevelListener interface to
 * receive callbacks from admin regarding change in the connector-service
 * monitoring level.
 * 
 * Though there are 3 monitoring levels defined by JSR77, we support
 * only 2 levels - OFF and ON (HIGH/LOW). So essentially, HIGH and LOW
 * for us is only ON
 * 
 * @author Sivakumar Thyagarajan
 * @since sjsas pe/se/ee 8.1
 */

public class ConnectorServiceMonitoringLevelListener 
                            implements MonitoringLevelListener {

    private ConnectorPoolMonitoringLevelListener ccpPoolMonitoringLevelListener_;
    private ConnectorWorkMonitoringLevelListener cwMonitoringLevelListener_;

    public ConnectorServiceMonitoringLevelListener(){
        ccpPoolMonitoringLevelListener_ = new ConnectorPoolMonitoringLevelListener();
        cwMonitoringLevelListener_ = new ConnectorWorkMonitoringLevelListener();
    }


    /**
     * @see com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener#setLevel(com.sun.enterprise.admin.monitor.registry.MonitoringLevel)
     * @deprecated
     */
    //remove after admin removes it
    public void setLevel( MonitoringLevel level ) {}
    
    /**
     * This is the callback invoked by the MonitoringRegistry
     * on change in monitoring level
     * 
     * @param from - the past level
     * @param to - the new level
     * @param handback - the Stats object this listener was registered for
     * @deprecated 
     */
    public void changeLevel( MonitoringLevel from, MonitoringLevel to,
        Stats handback ) {}

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, 
            MonitoredObjectType type) {
        /*        
         * For backward compatability reasons: When connector connection pool or 
         * the JMS-Service module monitoring level is updated, the connector 
         * service's module monitoring level listener is updated and vice-versa.
         * 
         * Change levels in connector connection pools and
         * connector work management level listeners as well.
         */        
        ccpPoolMonitoringLevelListener_.changeLevel(from, to, type);
        cwMonitoringLevelListener_.changeLevel(from, to, type);
    }
}