/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.security;

import java.security.BasicPermission;


/**
 * This object represents the permission to invoke on a set of CORBA objects
 * that are not EJBs.
 * The name is the CORBA Object's name (currently only "*" is supported).
 * The actions are the methods on the object.
 *
 * This class extends BasicPermission to support wildcard matching.
 */
public class CORBAObjectPermission extends BasicPermission {

    public CORBAObjectPermission() {
	
	super("*", "*");
    }

    public CORBAObjectPermission(String name) {

	super("*", "*");

	// currently only name "*" is supported
	if ( !name.equals("*") ) {
	    throw new RuntimeException("CORBAObjectPermission name must be *");
	}
    }

    public CORBAObjectPermission(String name, String actions) {

	super("*", actions);
	
	// currently only name "*" is supported
	if ( !name.equals("*") ) {
	    throw new RuntimeException("CORBAObjectPermission name must be *");
	}
    }
}
