/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.logging.*;
import javax.security.auth.callback.*;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.*;


/**
 * This implementation of LoginDialog, first looks at the environment
 * variables "login.username" and "login.password". If these are set it 
 * uses these for username & password respectively.
 * If these are not set, then it queries the user in the command window.
 *
 * @author Harish Prabandham
 */
public final class TextLoginDialog implements LoginDialog {

    private static Logger _logger=null;
    static {
        _logger=LogDomains.getLogger(LogDomains.SECURITY_LOGGER);
    }

    private String username = null;
    private String password = null;
    private static LocalStringManagerImpl localStrings =
	new LocalStringManagerImpl(TextLoginDialog.class);

    public TextLoginDialog() {
        BufferedReader d = 
            new BufferedReader(new InputStreamReader(System.in)); 
        do {
            System.out.print
                (localStrings.getLocalString
                    ("enterprise.security.login.username",
                    "User Name: "));
            try {
                username = d.readLine();
            } catch(IOException e) {
            }
        } while ((username == null) || (username.trim().length() == 0));
            
        do {
            System.out.print
                (localStrings.getLocalString
                    ("enterprise.security.login.password",
                    "Password: "));
            try {
                password = d.readLine();
            }catch (IOException e) {
            }
        } while ((password == null) || (password.trim().length() == 0));
    }

    public TextLoginDialog(Callback[] callbacks) 
    {
	try {
	    for(int i = 0; i < callbacks.length; i++) {
		if(callbacks[i] instanceof NameCallback) {
		    NameCallback nc = (NameCallback) callbacks[i];
		    System.err.print(nc.getPrompt());
		    System.err.flush();
		    nc.setName((new BufferedReader
				(new
				 InputStreamReader(System.in))).readLine());
		    
		} else if(callbacks[i] instanceof PasswordCallback) {
		    PasswordCallback pc = (PasswordCallback) callbacks[i];
                    char[] passwd;
                    Object consoleObj = null;
                    Method readPasswordMethod = null;
                    try {
                        Method consoleMethod = System.class.getMethod("console");
                        consoleObj = consoleMethod.invoke(null);
                        readPasswordMethod =
                            consoleObj.getClass().getMethod(
                            "readPassword", String.class,
                            Array.newInstance(Object.class, 1).getClass()); 
                    } catch(Exception ex) {
                    }

                    if (consoleObj != null && readPasswordMethod != null) {
                        passwd = (char[])readPasswordMethod.invoke(
                            consoleObj, "%s",
                            new Object[] { pc.getPrompt() });
                    } else {
		        System.err.print(pc.getPrompt());
		        System.err.flush();
		    
		        String psswd = 
			    new BufferedReader
			    (new InputStreamReader(System.in)).readLine();
                        passwd = psswd.toCharArray();
                    }
                    if (passwd != null) {
		        pc.setPassword(passwd);
                        Arrays.fill(passwd, ' ');
                    }
		} else if(callbacks[i] instanceof ChoiceCallback) {
		    ChoiceCallback cc = (ChoiceCallback) callbacks[i];
		    /* Get the keystore password to see if the user is 
		     * authorized to see the list of certificates
		     */
		    String lbl = (localStrings.getLocalString
				  ("enterprise.security.keystore",
				   "Enter the KeyStore Password "));
		    String keystorePass = SSLUtils.getKeyStorePass ();
		    System.out.println (lbl+
					" : (max 3 tries)"); 
		    int cnt=0;
		    for (cnt=0; cnt<3; cnt++){
			// Let the user try putting password thrice
			System.out.println (lbl+" : "); 
			String kp = 
			    (new BufferedReader
			     (new InputStreamReader(System.in))).readLine();
			if (kp.equals (keystorePass)) {
			    break; 
			} else{
			    String errmessage = localStrings.getLocalString("enterprise.security.IncorrectKeystorePassword","Incorrect Keystore Password");
			    System.err.println (errmessage); 
			}
		    }
		    if (cnt>=3){
			cc.setSelectedIndex (-1);
		    } else {
			System.err.println(cc.getPrompt());
			System.err.flush();
			String[] choices = cc.getChoices();
			for(int j = 0; j < choices.length; j++) {
			    System.err.print("[" + j + "] ");
			    System.err.println(choices[j]);
			}
			String line = 
			    (new BufferedReader
			     (new InputStreamReader(System.in))).readLine();
			
			int sel = new Integer(line).intValue();
			// System.out.println("SELECTED VAL:" + sel);
			cc.setSelectedIndex(sel);
		    }
		}
	    }
	} catch(Exception e) {
	    _logger.log(Level.SEVERE,
                        "java_security.name_password_entry_exception",e);
	}

    }

  
    /**
     * @return The username of the user.
     */
    public String getUserName() {
	return username;
    }
    /**
     *@return The password of the user in plain text...
     */
    public String getPassword() {
	return password;
    }
}
