/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.acl;

import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactory;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapper;
import java.util.Map;
import java.util.HashMap;
/**
 *
 * @author  Jerome Dochez
 */
public class RoleMapperFactory implements SecurityRoleMapperFactory {
    private static Map CONTEXT_TO_APPNAME = new HashMap();
    /** Creates a new instance of RoleMapperFactory */
    public RoleMapperFactory() {
    }
    
    /** Returns a RoleMapper corresponding to the AppName.
     * @param The Application Name of this RoleMapper.
     *
     */
    public SecurityRoleMapper getRoleMapper(String appName) {
        // if the appName is not appname but contextid for
        // web apps then get the appname
        String contextId = appName;
        String appname = getAppNameForContext(appName);
        SecurityRoleMapper srm = null;
        if(appname != null)
            srm = RoleMapper.getRoleMapper(appname);
        if(srm == null){
            srm = RoleMapper.getRoleMapper(contextId);
        }
        return srm;
    }
     
    /**
     * remove the RoleMapping associated with this application
     * @param the application name for this RoleMapper
     */
    public void removeRoleMapper(String appName) {
        RoleMapper.removeRoleMapper(appName);
    }
    
    /**
     * Sets a new RoleMapper for a particular Application
     * @param the application name
     * @param the new role mapper
     */
    public void setRoleMapper(String appName, SecurityRoleMapper rmap) {
        RoleMapper.setRoleMapper(appName, rmap);
    }
    
    public String getAppNameForContext(String contextId) {
        return (String)CONTEXT_TO_APPNAME.get(contextId);
    }
    
    public void setAppNameForContext(String appName, String contextId) {
        CONTEXT_TO_APPNAME.put(contextId, appName); 
    }
    
    public void removeAppNameForContext(String contextId) {
        CONTEXT_TO_APPNAME.remove(contextId);
    }
    
}
