/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security.auth;

import com.sun.enterprise.util.*;
import javax.rmi.PortableRemoteObject;
import javax.rmi.CORBA.Tie;
import org.omg.CORBA.ORB;

/**
 * Just a Base class to make exporting remote objects a bit easier...
 * @author Harish Prabandham
 */

public class RemoteObject {
    private ORB orb;

    protected RemoteObject() {
	orb = ORBManager.getORB();
    }

    protected void exportObject(java.rmi.Remote remote)
    throws java.rmi.RemoteException {
        // create servant and tie
        PortableRemoteObject.exportObject(remote);
        Tie servantsTie = javax.rmi.CORBA.Util.getTie(remote);

        // Note: at this point the Tie doesnt have a delegate inside it,
        // so it is not really "exported".
        // The following call does orb.connect() which is the real exporting
        servantsTie.orb(orb);
    }

    java.rmi.Remote getStub(java.rmi.Remote remote)
    throws java.rmi.RemoteException {
	return PortableRemoteObject.toStub(remote);
    }
}





