/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * FactoryForSecurityManagerFactoryImpl.java
 *
 * Created on June 9, 2003, 1:51 PM
 */

package com.sun.enterprise.security.factory;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/**
 * Creates a Singleton for FactoryForSecurityManagerImpl
 * @author  Harpreet Singh
 */
public class FactoryForSecurityManagerFactoryImpl 
    implements FactoryForSecurityManagerFactory {

    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    
    private static FactoryForSecurityManagerFactory _theFactory; 
    private static String WEB = "web";
    private static String EJB = "ejb";
    
    /** Creates a new instance of FactoryForSecurityManagerFactoryImpl */
    private FactoryForSecurityManagerFactoryImpl() {
    }
    
    public static FactoryForSecurityManagerFactory getInstance() {
        try {
            rwLock.readLock().lock();
            if (_theFactory != null) {
                return _theFactory;
            }
        } finally {
            rwLock.readLock().unlock();
        }

        try {
            rwLock.writeLock().lock();
            if (_theFactory == null) {
                _theFactory = new FactoryForSecurityManagerFactoryImpl();
            }
            return _theFactory;
        } finally {
            rwLock.writeLock().unlock();
        }
    }
    /* @todo uncommnent the web route
     *
     */
    public SecurityManagerFactory getSecurityManagerFactory(String type) {
        if(type.equalsIgnoreCase(WEB)){
//            return WebSecurityManagerFactory.getInstance();            
        } else if (type.equalsIgnoreCase(EJB)){
            return EJBSecurityManagerFactory.getInstance();
        }
        return null;
    }
}
