/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ContainerCallbackHandler
 *
 * Created on April 21, 2004, 11:56 AM
 */

package com.sun.enterprise.security.jmac.callback;

import java.io.IOException;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

import com.sun.enterprise.Switch;
import com.sun.enterprise.security.jmac.config.CallbackHandlerConfig;
import com.sun.enterprise.security.jmac.config.HandlerContext;

/**
 * @author  Shing Wai Chan
 */
public final class ContainerCallbackHandler 
        implements CallbackHandler, CallbackHandlerConfig {
    private CallbackHandler handler = null;

    public ContainerCallbackHandler() {
        if (Switch.getSwitch().getContainerType() == Switch.APPCLIENT_CONTAINER)
 {
            handler = new ClientContainerCallbackHandler();
        } else {
            handler = new ServerContainerCallbackHandler();
        }
    }

    public void handle(Callback[] callbacks)
            throws IOException, UnsupportedCallbackException {
        handler.handle(callbacks);
    }

    public void setHandlerContext(HandlerContext handlerContext) {
        ((CallbackHandlerConfig)handler).setHandlerContext(handlerContext);
    }
}
