/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jmac.config;
import java.lang.reflect.Method;
import java.rmi.UnmarshalException;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.PrivilegedActionException;

import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.ClientAuthConfig;
import javax.security.auth.message.config.ClientAuthContext;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.auth.message.config.AuthConfigFactory.RegistrationContext;

import javax.xml.namespace.QName;

import com.sun.ejb.Container;
import com.sun.ejb.Invocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;

import com.sun.enterprise.deployment.runtime.common.MessageSecurityBindingDescriptor;

import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.audit.AuditManagerFactory;
import com.sun.enterprise.security.ClientSecurityContext;
import com.sun.enterprise.security.AppservAccessController;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.jmac.AuthMessagePolicy;
import com.sun.enterprise.security.jmac.config.CallbackHandlerConfig;
import com.sun.enterprise.security.jmac.config.GFServerConfigProvider;
import com.sun.enterprise.security.jmac.config.HandlerContext;
import com.sun.enterprise.webservice.PipeConstants;
import com.sun.enterprise.util.LocalStringManagerImpl;

import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.model.JavaMethod;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.server.WSEndpoint;

public class PipeHelper extends ConfigHelper {
    private static AuditManager auditManager =
            AuditManagerFactory.getAuditManagerInstance();

    protected static final LocalStringManagerImpl localStrings = 
        new LocalStringManagerImpl(PipeConstants.class);

    private boolean isEjbEndpoint;
    private SEIModel seiModel;

    public PipeHelper(String layer, Map map, CallbackHandler cbh) {
        super(layer, getAppCtxt(map), map, cbh);

	this.isEjbEndpoint = processSunDeploymentDescriptor();
	this.seiModel = (SEIModel) map.get(PipeConstants.SEI_MODEL);
   }

    public ClientAuthContext getClientAuthContext(MessageInfo info, Subject s) 
    throws AuthException {
	ClientAuthConfig c = (ClientAuthConfig)getAuthConfig(false);
	if (c != null) {
            addModel(info, map);
	    return c.getAuthContext(c.getAuthContextID(info),s,map);
	}
	return null;
    }

    public ServerAuthContext getServerAuthContext(MessageInfo info, Subject s) 
    throws AuthException {
	ServerAuthConfig c = (ServerAuthConfig)getAuthConfig(true);
	if (c != null) {
            addModel(info, map);
	    return c.getAuthContext(c.getAuthContextID(info),s,map);
	}
	return null;
    }

    public static Subject getClientSubject() {

	Subject s = null;

	if (Switch.getSwitch().getContainerType() == 
	    Switch.APPCLIENT_CONTAINER) {

	    ClientSecurityContext sc = ClientSecurityContext.getCurrent();
	    if (sc != null) {
		s = sc.getSubject();
	    }

	    if (s == null) {
		s = Subject.getSubject(AccessController.getContext());
	    }

	} else {
	    SecurityContext sc = SecurityContext.getCurrent();
	    if (sc != null && !sc.didServerGenerateCredentials()) {
		// make sure we don't use default unauthenticated subject, 
		// so that module cannot change this important (constant) 
		// subject.
		s = sc.getSubject();
	    }
	}

	if (s == null) {
	    s = new Subject();
	}

	return s;
    }

    public void getSessionToken(Map m, 
				MessageInfo info, 
				Subject s) throws AuthException {
	ClientAuthConfig c = (ClientAuthConfig) getAuthConfig(false);    
	if (c != null) {
	    m.putAll(map);
            addModel(info, map);
	    c.getAuthContext(c.getAuthContextID(info),s,m);
	}
	return;
    }

    public void authorize(Packet request) throws Exception {

	// SecurityContext constructor should set initiator to
	// unathenticated if Subject is null or empty

	Subject s = (Subject) request.invocationProperties.get
	    (PipeConstants.CLIENT_SUBJECT);

	SecurityContext sC = new SecurityContext(s);

	SecurityContext.setCurrent(sC);

	// we should try to replace this endpoint specific
	// authorization check with a generic web service message check
	// and move the endpoint specific check down stream
	if (isEjbEndpoint) {

	    Switch theSwitch = Switch.getSwitch();
	    InvocationManager invManager= theSwitch.getInvocationManager();
	    Invocation inv= (Invocation) invManager.getCurrentInvocation();
	    Exception ie = null;
            Method m = null;
            if (seiModel != null) {
	        JavaMethod jm = request.getMessage().getMethod(seiModel);
	        m = (jm != null) ? jm.getMethod() : null;
            } else { // WebServiceProvider
               WebServiceEndpoint endpoint = (WebServiceEndpoint)
                   map.get(PipeConstants.SERVICE_ENDPOINT);
               EjbDescriptor ejbDescriptor = endpoint.getEjbComponentImpl();
               if (ejbDescriptor != null) {
                   final String ejbImplClassName = ejbDescriptor.getEjbImplClassName();
                   if (ejbImplClassName != null) {
                       try {
                           m = (Method)AppservAccessController.doPrivileged
                               ( new PrivilegedExceptionAction() {
                                   public Object run() throws Exception {
                                       ClassLoader loader =
                                           Thread.currentThread().getContextClassLoader();
                                       Class clazz =
                                           Class.forName(ejbImplClassName, true, loader);
                                       return clazz.getMethod("invoke",
                                               new Class[] { Object.class });
                                  }
                           });
                       } catch(PrivilegedActionException pae) {
                           throw new RuntimeException(pae.getException());
                       }
                   }
               }

            }
	    
	    if (m != null) {

		Container container = (Container) inv.container;

		try {
		    inv.method = m;
		    if ( !container.authorize(inv) ) {

			ie = new Exception
			    (localStrings.getLocalString
			     ("enterprise.webservice.methodNotAuth",
			      "Client not authorized for invocation of {0}", 
			      new Object[] { inv.method }) );
		    } else {
			// Record the method on which the successful
			// authorization check was performed. 
			inv.setWebServiceMethod(inv.method);
		    }
		} catch(Exception e) {
		    String errorMsg = localStrings.getLocalString
			( "enterprise.webservice.errorUnMarshalMethod",
			  "Error unmarshalling method for ejb {0}", 
			  new Object[] { ejbName() });
		    ie = new UnmarshalException(errorMsg); 
		    ie.initCause(e);
		} 
		
		if ( ie != null ) {
		    inv.exception = ie;
		    throw ie;
		} 

	    } else {
		inv.setWebServiceMethod(null);
	    }
	}
            
	return;
    }
	
    public void auditInvocation(Packet request, AuthStatus status) {

	if (auditManager.isAuditOn()) {

	    String uri = null;
	    if(request != null ) {
		uri = request.endpointAddress.toString();
	    } 
	    
            //XXX distinguish ejb vs servlet endpoint
            //XXX use endpointname vs appCtxt
	    auditManager.webServiceInvocation
		(((uri==null) ? "(no uri)" : uri), 
		  ((appCtxt == null) ? "(no endpoint)" : appCtxt), 
		  (status == AuthStatus.SUCCESS ? true : false));
	}
    }

    protected HandlerContext getHandlerContext(Map map) {
        String realmName = null;
        WebServiceEndpoint wSE = (WebServiceEndpoint)
                map.get(PipeConstants.SERVICE_ENDPOINT);
        if (wSE != null) {
            Application app = wSE.getBundleDescriptor().getApplication();
            if (app != null) {
                realmName = app.getRealm();
            }
            if (realmName == null) {
                realmName = wSE.getRealm();
            }
        }

        final String fRealmName = realmName;
        return new HandlerContext() {
            public String getRealmName() {
                return fRealmName;
            }
        };
    }

    private boolean processSunDeploymentDescriptor() {

	if (factory == null) {
	    return false;
	}

	MessageSecurityBindingDescriptor binding =
	    AuthMessagePolicy.getMessageSecurityBinding
	    (PipeConstants.SOAP_LAYER,map);

	boolean register = (binding != null);

	if (register) {
	    // XXX this may need to be optimized
	    AuthConfigProvider p = 
		factory.getConfigProvider(layer,appCtxt,null);
	    if (p != null) {
		String[] IDs = factory.getRegistrationIDs(p);
		for ( String i : IDs ) {
		    RegistrationContext c = factory.getRegistrationContext(i);
		    if (layer.equals(c.getMessageLayer()) && 
			appCtxt.equals(c.getAppContext())) {
			register = false;
			break;
		    }
		}
	    }

	    if (register) {
		factory.registerConfigProvider(
                    new GFServerConfigProvider(null, null),
                    layer, appCtxt,
                    "GF AuthConfigProvider bound by Sun Specific Descriptor");
	    }
	}

	WebServiceEndpoint e = (WebServiceEndpoint)
	    map.get(PipeConstants.SERVICE_ENDPOINT);

	return (e == null ? false : e.implementedByEjbComponent());
    }

    private static String getAppCtxt(Map map) {
	QName portName = null;
	QName serviceName = null;
	WSEndpoint e = (WSEndpoint) map.get(PipeConstants.ENDPOINT);
	if (e != null) {
	    portName = e.getPortName();
	    serviceName = e.getServiceName();
	} else {
	    WSDLPort p = (WSDLPort) map.get(PipeConstants.WSDL_MODEL);
	    if (p != null) {
		portName = p.getName();
		WSDLService s = p.getOwner();
		if (s != null) {
		    serviceName = s.getName();
		}
	    }
	}
	return 
	    (serviceName == null ? "" : serviceName.getLocalPart()) + " " +
	    (portName == null ? "" : portName.getLocalPart());
    }

    private static void addModel(MessageInfo info, Map map) {
        Object model = map.get(PipeConstants.WSDL_MODEL);
        if (model != null) {
            info.getMap().put(PipeConstants.WSDL_MODEL,model);
        }
    }

    private String ejbName() { 
	WebServiceEndpoint wSE = (WebServiceEndpoint) 
	    getProperty(PipeConstants.SERVICE_ENDPOINT);
	return (wSE == null ? "unknown" : wSE.getEjbComponentImpl().getName());
    }
}
