/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server;

import com.sun.enterprise.config.*;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.connectors.util.ResourcesUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.*;

import com.sun.logging.LogDomains;
import com.sun.enterprise.connectors.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.util.io.FileUtils;

/**
  *
  * @author    Srikanth P
  * @version
 */

public class ConnectorResourcesLoader  extends ResourcesLoader{

    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);
    
    /** context of the server instance runtime */


    public ConnectorResourcesLoader() throws ConfigException{
        super(); 
    }



    public void load() {
        ConfigBean[][] cb = null;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            cb = resourceUtil.getConnectorResources();
            if(cb != null)
                load(cb);
        }
        catch(ConfigException ce) {
            _logger.log(Level.SEVERE,"core.connectorresource_read_error" );
            _logger.log(Level.SEVERE,"" ,ce);
        }
    }

    public void load(boolean standAloneRarsOnly) {
        ConfigBean[][] cb = null;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            if(standAloneRarsOnly) {
                cb = resourceUtil.getStandAloneNonSystemRarConnectorResources();
            } else {
                cb = resourceUtil.getConnectorResources(standAloneRarsOnly);
            }
            if(cb != null)
                load(cb);
        }
        catch(ConfigException ce) {
            _logger.log(Level.SEVERE,"core.connectorresource_read_error" );
            _logger.log(Level.SEVERE,"" ,ce);
        }
    }

    public void loadRAConfigs() {
        ConfigBean[][] cb = new ConfigBean[1][];;
        try {
            ConfigBean[] raConfBeans = ResourcesUtil.createInstance().getResourceAdapterConfigs();
            if(raConfBeans != null) {
                cb[0] = raConfBeans;
                load(cb);
            }
        }
        catch(ConfigException ce) {
            _logger.log(Level.SEVERE,"core.connectorresource_read_error" );
            _logger.log(Level.SEVERE,"" ,ce);
        }
    }

    public void load(String rarName) {

        ConfigBean[][] cb = null;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            cb = resourceUtil.getAllConnectorResourcesForRar(rarName);
            if(cb != null)
                load(cb);
        }
        catch(ConfigException ce) {
            _logger.log(Level.SEVERE,"core.connectorresource_read_error" );
            _logger.log(Level.SEVERE,"" ,ce);

        }
    }
    
    public void loadRAConfigs(String rarName) {
        ConfigBean[][] cb = new ConfigBean[1][];;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            ConfigBean[] raConfBeans = resourceUtil.getResourceAdapterConfigs(rarName);
            if(raConfBeans != null) {
                cb[0] = raConfBeans;
                load(cb);
            }
        }
        catch(ConfigException ce) {
            _logger.log(Level.SEVERE,"core.connectorresource_read_error" );
            _logger.log(Level.SEVERE,"" ,ce);
        }
    }

    public void loadEmbeddedRarRAConfigs(String appName) {
        ConfigBean[][] cb = new ConfigBean[1][];;
        try {
            ResourcesUtil resourceUtil = ResourcesUtil.createInstance();
            ConfigBean[] raConfBeans = 
                    resourceUtil.getEmbeddedRarResourceAdapterConfigs(appName);
            if(raConfBeans != null) {
                cb[0] = raConfBeans;
                load(cb);
            }
        }
        catch(ConfigException ce) {
            _logger.log(Level.SEVERE,"core.connectorresource_read_error" );
            _logger.log(Level.SEVERE,"" ,ce);
        }
    }

    public void loadEmbeddedRarResources(String appName, Application appDesc) {

        Set rars = appDesc.getRarDescriptors();

        for (Iterator itr = rars.iterator(); itr.hasNext();) {
            ConnectorDescriptor cd = (ConnectorDescriptor) itr.next();
            String rarName = cd.getDeployName();
            String embeddedRarName = appName+
                       ConnectorConstants.EMBEDDEDRAR_NAME_DELIMITER+
                       FileUtils.makeFriendlyFilenameNoExtension(rarName);
            load(embeddedRarName);
        }
    }
    
    public void stopActiveResourceAdapters(){
        ConnectorRuntime.stopAllActiveResourceAdapters();
    }
    
}