/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server;

import javax.management.MBeanException;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.deployment.Descriptor;

import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.logging.LogDomains;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.server.event.ApplicationEvent;

/**
 * This is just a dummy module loader for web application. The only responsibility
 * of this class is to generate a notifictation event so that ondemand init code
 * can load the web applications as the appserver starts up.
 * 
 * @author Binod PG
 */
public class DummyWebModuleLoader extends AbstractLoader {

    static Logger _logger=LogDomains.getLogger(LogDomains.LOADER_LOGGER);

    /**
     * Constructs a dummy loader. It generates a descriptor representing 
     * the webapp.
     */
    DummyWebModuleLoader(String id, ClassLoader loader, WebModulesManager manager) {
        super(id, loader, manager);
        try {
            this.application = manager.getDescriptor(id, manager.getLocation(id));
            manager.setLoadOnStartup(application);
        } catch (ConfigException confEx) {
            _logger.log(Level.SEVERE,"loader.configexception", confEx);
        }
    }

    //Dummy load. Notification is fired here.
    boolean load(boolean jsr77) {
        notifyAppEvent(ApplicationEvent.BEFORE_APPLICATION_LOAD);
        loadWebserviceEndpoints(jsr77);
        return true;
    }

    boolean unload(boolean jsr77) {
        unloadWebserviceEndpoints(jsr77);
        return true;
    }

    void createRootMBean () throws MBeanException {
    }

    void deleteRootMBean () throws MBeanException{
    }

    void createLeafMBeans () throws MBeanException{
    }

    void deleteLeafMBeans () throws MBeanException {
    }

    void createLeafMBean (Descriptor descriptor) throws MBeanException {
    }

    void deleteLeafMBean (Descriptor descriptor) throws MBeanException {
    }

    void deleteLeafAndRootMBeans () throws MBeanException {
    }

    void setState(int state) throws MBeanException {
    }
}
