/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.server;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.loader.InstrumentableClassLoader;

import javax.persistence.EntityManagerFactory;
import java.util.Collection;

/**
 * This is used by {@link AbstractLoader} to load persistence units embedded in
 * an ear file. It recurssively loads all the persistence units.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public interface PersistenceUnitLoader {
    /**
     * This encapsulates information needed by {@link PersistenceUnitLoader}
     * to load or unload persistence units.
     */
    interface ApplicationInfo {
        /**
         * @return {@link Application} whose persistence units will be
         * loaded or unloaded.
         */
        Application getApplication();

        /**
         *
         * @return a class loader that is used to load persistence entities
         * bundled in this application.
         */
        InstrumentableClassLoader getClassLoader();

        /**
         * @return absolute path of the location where application is exploded.
         */
        String getApplicationLocation();

        /**
         * This method returns the precise list of PUs that are
         * referenced by the components of this application.
         * A component references by a PU using one of the four
         * methods: @PersistenceContext, @PersistenceUnit,
         * <persistence-context-ref> and <persistence-unit-ref>.
         * This interface is known to be implemented in WebContainer,
         * ACC, EAR container and in Java2DB code.
         * @return list of PU that are actually referenced by this application.
         */
        Collection<? extends PersistenceUnitDescriptor> getReferencedPUs();

        /**
         * Returns the EntityManagerFactories that needs to be closed.
         * This interface is known to be implemented in WebContainer,
         * ACC, EAR container and in Java2DB code.
         *
         * @return the list of EMFs that need to be closed.
         */
        Collection<? extends EntityManagerFactory> getEntityManagerFactories();

    }

    /**
     * Load all the persistence units contained inside the application described
     * by ApplicationInfo object. Loading involves calling the {@link
     * javax.persistence.spi.PersistenceProvider} to create an {@link
     * javax.persistence.EntityManagerFactory} and registering the {@link
     * javax.persistence.EntityManagerFactory} at the appropriate level in
     * {@link Application} descriptor object tree.
     */
    void load(ApplicationInfo appInfo);

    /**
     * Unload all the persistence units contained inside the application
     * described by ApplicationInfo object. Unloading involves calling {@link
     * javax.persistence.EntityManagerFactory#close()} for each {@link
     * javax.persistence.EntityManagerFactory} in {@link Application} descriptor
     * object tree.
     */
    void unload(ApplicationInfo appInfo);
}
