/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.ss.util;

                                                                                                                             
/**
 * When nio application uses Selector.selectedKeys(),
 * ASSelector will return a ASSet instance, where it will wrap 
 * those selection keys used for OP_ACCEPT.
 * Nio application might use Set.iterator() to remove the
 * processed SelectionKey from the selectedSet. We provide 
 * a wrapper Iterator so that even the actual selectedSet in
 * the Selector is modified.
 * 
 * @see ASSelector
 */
public class ASIterator implements java.util.Iterator {
 
    java.util.Iterator it = null;
    ASSet asSet = null;

    public ASIterator(ASSet asSet) {
        this.it = asSet.actualSet().iterator();
        this.asSet = asSet;
    }

    public Object next() {
        return asSet.wrapIfNecessary(it.next());
    }

    public boolean hasNext() {
        return it.hasNext();
    }

    public void remove() {
        it.remove();
    }
}
