/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.common.util.diagnostics;

import java.io.*;
import java.util.*;
import com.sun.enterprise.tools.common.util.StringUtils;

/** The basic mechanism used to "report".
 *
 * sends output to a Swing window.
 */
public class ReporterWriter implements IReporterEnum
{
    /** Create a new place (or mechanism) for routing output from the Reporter classes.
     *
     * @param title The title of the output window
     */    
	protected ReporterWriter(String title)
	{
		this.title = title;
		out = System.out;
	}

	///////////////////////////////////////////////////////////////
	
        /** puts a message in the window.
         *
         * Subclasses should redefine this function to change the report output destination.
         * @param severity The severity level of the message.  This is translated into one of the named constants
         * for output.
         * @param s The text of the message to "report".
         */        
	protected void println(int severity, String s)
	{
		String type;
		String msg;
		
		/*
		if(severity > WARN)
		{
			type = "<B>" + severityNames[severity] + "</B>";
			msg = StringUtils.padRight(type, longestSeverityLength + 7) + s;
		}
        else
		*/
		{
			type = severityNames[severity];
			msg = StringUtils.padRight(severityNames[severity], longestSeverityLength) + s;
		}

        out.println(msg);
		getFrame().pr(msg);
	}

	///////////////////////////////////////////////////////////////
	
	private ReporterFrame getFrame()
	{
		if(frame == null)
		{
			// first call!!
			frame = new ReporterFrame(title);
			frame.show();
			calcLongestString();
		}

		return frame;
	}

	///////////////////////////////////////////////////////////////
	
	private void calcLongestString()
	{
		int maxLen = 0;

		for(int i = 0; i < severityNames.length; i++)
		{
			int len = severityNames[i].length();

			if(len > maxLen)
				maxLen = len;
		}
		longestSeverityLength = maxLen + 2;
	}

	///////////////////////////////////////////////////////////////
	
	private PrintStream		out;
	private	ReporterFrame	frame	= null;
	private	int				longestSeverityLength;
	private String			title;

}

