/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.transaction;

import javax.transaction.*;
import javax.resource.spi.XATerminator;
import com.sun.enterprise.*;
import javax.transaction.xa.Xid;
import com.sun.enterprise.distributedtx.J2EETransactionManagerOpt;

/**
* This class is wrapper for the actual transaction manager implementation.
* JNDI lookup name "java:appserver/TransactionManager"
* see the com/sun/enterprise/naming/java/javaURLContext.java
**/

public class TransactionManagerHelper implements TransactionManager, TransactionImport {

    public void begin() throws NotSupportedException, SystemException {
	Switch.getSwitch().getTransactionManager().begin();
    }

    
    public void commit() throws RollbackException,
	HeuristicMixedException, HeuristicRollbackException, SecurityException,
	IllegalStateException, SystemException {
	Switch.getSwitch().getTransactionManager().commit();
    }

    public int getStatus() throws SystemException {
	return Switch.getSwitch().getTransactionManager().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
	return Switch.getSwitch().getTransactionManager().getTransaction();
    }

    
    public void resume(Transaction tobj)
            throws InvalidTransactionException, IllegalStateException,
            SystemException {
	Switch.getSwitch().getTransactionManager().resume(tobj);
    }

    
    public void rollback() throws IllegalStateException, SecurityException,
                            SystemException {
	Switch.getSwitch().getTransactionManager().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
	Switch.getSwitch().getTransactionManager().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
	Switch.getSwitch().getTransactionManager().setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
	return Switch.getSwitch().getTransactionManager().suspend();
    }

    public static TransactionManager getTransactionManager() {
	return tmHelper;
    }
    
    public void recreate(Xid xid, long timeout) {
        final J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        
        try {
            tm.recreate(xid, timeout);
        } catch (javax.resource.spi.work.WorkException ex) {
            throw new IllegalStateException(ex);
        }
       
        final ComponentInvocation inv = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
        Transaction tran = null;
        if (inv != null) {
            int invType = inv.getInvocationType();
            if (invType == ComponentInvocation.SERVLET_INVOCATION) {
                try {
                    if ((tran = tm.getTransaction()) != null) {
                        inv.setTransaction(tran);
                    }
                } catch (SystemException se ) {
                }
            }
        }
    }

    public void release(Xid xid) {
        IllegalStateException rethrow = null;
        final J2EETransactionManager tm = Switch.getSwitch().getTransactionManager();
        
//        final ComponentInvocation inv = Switch.getSwitch().getInvocationManager().getCurrentInvocation();
//        Transaction tran = null;
//        if (inv != null) {
//            if (inv.getInvocationType() == ComponentInvocation.SERVLET_INVOCATION) {
//                try{
//                    tm.delistComponentResources(false);
//                } catch (java.rmi.RemoteException re) {
//                //TODO: enhance exception handling here
//                }
//             }
//       }
     
        try {
            tm.release(xid);    
        } catch (javax.resource.spi.work.WorkException ex) {
            throw new IllegalStateException(ex);
        }  finally { 
            if (tm instanceof J2EETransactionManagerOpt) {
                ((J2EETransactionManagerOpt) tm).clearThreadTx();
            }
            if (rethrow != null) {
                throw rethrow;
            }
        } 
    }
    
    public XATerminator getXATerminator() {
        return Switch.getSwitch().getTransactionManager().getXATerminator();
    }


    private static TransactionManagerHelper tmHelper = new TransactionManagerHelper();

    
    
}
