/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.web;


/**
 * Static constants for this package.
 */

public final class Constants {

    public static final String Package = "com.sun.enterprise.web";

    /**
     * The default web application's deployment descriptor location.
     *
     * This path is relative to catalina.home i.e. the instance root directory.
     */
    public static final String DEFAULT_WEB_XML = "config/default-web.xml";

    /**
     * The system-assigned default web module's name/identifier.
     *
     * This has to be the same value as is in j2ee/WebModule.cpp.
     */
    public static final String DEFAULT_WEB_MODULE_NAME = "__default-web-module";

    /**
     * The separator character between an application name and the web
     * module name within the application.
     */
    public static final String NAME_SEPARATOR = 
             com.sun.enterprise.server.Constants.NAME_SEPARATOR;

    /**
     * The string to prefix to the name of the web module when a web module
     * is designated to be the default-web-module for a virtual server.
     *
     * This serves as a way to differentiate the web module from the
     * variant that is deployed as a 'default web module' at a context root
     * of "".
     */
    public static final String DEFAULT_WEB_MODULE_PREFIX = "__default-";

    /**
     * Name of the class that implements invocation/security/transaction
     * manager hooks for web application events.
     */
    public static final String J2EE_INSTANCE_LISTENER =
        "com.sun.web.server.J2EEInstanceListener";

    /**
     * The Apache Jasper JSP servlet class name.
     */
    public static final String APACHE_JSP_SERVLET_CLASS =
        "org.apache.jasper.servlet.JspServlet";

    public static final String JSP_URL_PATTERN="*.jsp";


    public static final String REQUEST_START_TIME_NOTE =
        "com.sun.enterprise.web.request.startTime";

    public static final String ACCESS_LOG_PROPERTY = "accesslog";

    public static final String ACCESS_LOG_BUFFER_SIZE_PROPERTY =
        "accessLogBufferSize";

    public static final String ACCESS_LOG_WRITE_INTERVAL_PROPERTY =
        "accessLogWriteInterval";

    public static final String SSO_ENABLED = "sso-enabled";
}
