/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MonitorUtil.java
 *
 * Created on May 7, 2004, 2:09 PM
 */

package com.sun.enterprise.web;

import java.util.logging.*;
import com.sun.logging.*;
import org.apache.catalina.Context;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;

/**
 *
 * @author  lwhite
 */
public final class MonitorUtil {
    
    private static final Logger _logger;

    static {
        _logger = LogDomains.getLogger(LogDomains.WEB_LOGGER);
    }    
    
    /**
     * Resets the stats of all web modules.
     */ 
    public static void resetMonitorStats(EmbeddedWebContainer embedded,
                                         ServerContext serverContext) {

        MonitoringRegistry monitoringRegistry =
            serverContext.getMonitoringRegistry();

        Engine[] engines = embedded.getEngines();            
        for(int h=0; h<engines.length; h++) {
            Container engine = (Container) engines[h];            
            Container[] hosts = engine.findChildren();
            for(int i=0; i<hosts.length; i++) {
                Container nextHost = hosts[i];
                Container [] webModules = nextHost.findChildren();
                for (int j=0; j<webModules.length; j++) {
                    WebModule webModule = (WebModule) webModules[j];
                    if (!webModule.hasWebXml()) {
                        // Dummy root context
                        continue;
                    }
                    /*
                     * Standalone webmodules are loaded with the application
                     * name set to the string "null"
                     */
                    String j2eeApp = webModule.getJ2EEApplication();
                    if ("null".equalsIgnoreCase(j2eeApp)) {
                        j2eeApp = null;
                    }
                    WebModuleStats stats =
                        monitoringRegistry.getWebModuleStats(
                            j2eeApp,
                            webModule.getModuleName(),
                            webModule.getPath(),
                            nextHost.getName());
                    if (stats != null) {
                        try {
                            stats.reset();
                        } catch (Throwable th) {
                            _logger.log(Level.SEVERE,
                                        "Error resetting WebModuleStats", th);
                        }                
                    }
                }
            }
        }                 
    }  
    
}
