/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SessionPurgeUtil.java
 *
 * Created on March 10, 2003, 3:28 PM
 */

package com.sun.enterprise.web;

import java.util.logging.*;
import com.sun.logging.*;
import java.util.Hashtable;
import java.util.Enumeration;
import java.util.ArrayList;
import org.apache.catalina.Context;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.SessionPurgeCapable;
import java.sql.Connection;


/**
 *
 * @author  lwhite
 */
public final class SessionPurgeUtil {

    /**
     * The embedded Catalina object.
     */
    protected EmbeddedWebContainer _embedded = null;    
    private WebContainer webContainer = null;    
    private static final Logger _logger =LogDomains.getLogger(LogDomains.WEB_LOGGER);
    
    /** Creates a new instance of SessionPurgeUtil */
    public SessionPurgeUtil() {
    }
    

    /** Creates a new instance of SessionPurgeUtil */
    /*
    public SessionPurgeUtil(Hashtable instances)  {
        _instances = instances;
    }
     */
    
    /** Creates a new instance of SessionPurgeUtil */
    public SessionPurgeUtil(EmbeddedWebContainer embedded)  {
        _embedded = embedded;
    }     
    
     public String getApplicationId(Context ctx) {
        com.sun.enterprise.web.WebModule wm = 
            (com.sun.enterprise.web.WebModule)ctx;
        return wm.getID();
    }
     
     public String getApplicationName(Context ctx) {
        return ctx.getName();
    }
     
    public String getJ2EEApplicationName(Context ctx) {      
        return ((StandardContext)ctx).getJ2EEApplication();
    }
    
    public void purgeSessionsForContext(Context ctx) {
        Manager mgr = ctx.getManager();
        _logger.finest("SessionPurgeUtil: mgr = " + mgr);
        _logger.finest("SessionPurgeUtil: mgr SessionPurgeCapable: " + (mgr instanceof SessionPurgeCapable));
        if(mgr instanceof SessionPurgeCapable) {
            ((SessionPurgeCapable)mgr).clearSessions();
            ((SessionPurgeCapable)mgr).clearStore();
        }
    }
             
    public void purgeSessionsForApp(String appName) {
        _logger.finest("IN SessionPurgeUtil:purgeSessionsForApp" + appName);
        try {
            Engine[] engines = _embedded.getEngines();
            
            for(int h=0; h<engines.length; h++) {
                Container engine = (Container) engines[h];
                Container[] hosts = engine.findChildren();
                for(int i=0; i<hosts.length; i++) {
                    Container nextHost = hosts[i];
                    Container [] webModules = nextHost.findChildren();
                    for (int j=0; j<webModules.length; j++) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        //this code gets managers
                        //String webAppName = this.getApplicationId(ctx);
                        String webAppName = this.getApplicationName(ctx);
                        Manager nextManager = nextWebModule.getManager();
                        _logger.finest("webAppName = " + webAppName + ", appName = " + appName);
                        if(webAppName.equals(appName)) {
                            _logger.finest("found our manager:" + nextManager.getClass().getName());          
                            //call the clearSessions and clearStore
                            /*
                            if(nextManager instanceof PersistentManagerBase) {
                                ((PersistentManagerBase)nextManager).clearSessions();
                                ((PersistentManagerBase)nextManager).clearStore();
                            } 
                             */                           
                            if(nextManager instanceof SessionPurgeCapable) {
                                ((SessionPurgeCapable)nextManager).clearSessions();
                                ((SessionPurgeCapable)nextManager).clearStore();
                            }
                        }
                    }                    
                }                 
            }
        } catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
                
    }  
    
    public void closeCachedConnectionForApp(String appName) {
        _logger.finest("IN SessionPurgeUtil:closeCachedConnectionForApp" + appName);

        try {
            Engine[] engines = _embedded.getEngines();
            
            for(int h=0; h<engines.length; h++) {
                Container engine = (Container) engines[h];            
                Container[] hosts = engine.findChildren();
                for(int i=0; i<hosts.length; i++) {
                    Container nextHost = hosts[i];
                    Container [] webModules = nextHost.findChildren();
                    for (int j=0; j<webModules.length; j++) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        //this code gets managers
                        //String webAppName = this.getApplicationId(ctx);
                        String webAppName = this.getApplicationName(ctx);
                        Manager nextManager = nextWebModule.getManager();
                        _logger.finest("webAppName = " + webAppName + ", appName = " + appName);
                        if(webAppName.equals(appName)) {
                            _logger.finest("found our manager:" + nextManager.getClass().getName());
                            //close the cached connection of the dedicated store instance
                            if(nextManager instanceof ShutdownCleanupCapable) {
                                ShutdownCleanupCapable nextOne = (ShutdownCleanupCapable) nextManager;
                                nextOne.doCloseCachedConnection();
                            }
                        }
                    }                    
                }                 
            }
        } catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
                
    }       
    
}
