/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * WebDebugMonitor.java
 *
 * Created on January 14, 2003, 11:16 AM
 */

package com.sun.enterprise.web;

import java.util.*;
import java.util.logging.*;
import com.sun.logging.*;

/**
 *
 * @author  lwhite
 */
public final class WebDebugMonitor {
    
	private static final Logger _logger = LogDomains.getLogger(LogDomains.WEB_LOGGER);
    
    /** Creates a new instance of WebDebugMonitor */
    public WebDebugMonitor() {
    }
    
    HashMap getDebugMonitoringDetails() { 
        HashMap resultMap = new HashMap();
        boolean debugMonitoring = false;
        resultMap.put("debugMonitoring", Boolean.FALSE);
        long debugMonitoringPeriodMS = 30000L;
	try{
            Properties props = System.getProperties();
            String str=props.getProperty("MONITOR_WEB_CONTAINER");
            if(null!=str) {
                if( str.equalsIgnoreCase("TRUE"))
                //if( str.startsWith("TRUE") || str.startsWith("true") )
                    debugMonitoring=true;
            }
            String period=props.getProperty("MONITOR_WEB_TIME_PERIOD_SECONDS");
            if(null!=period) {
                debugMonitoringPeriodMS = (new Long (period).longValue())* 1000;
            }
            resultMap.put("debugMonitoringPeriodMS",
                          Long.valueOf(debugMonitoringPeriodMS));
            resultMap.put("debugMonitoring",
                          Boolean.valueOf(debugMonitoring));

        } catch(Exception e)
        {
            _logger.log(Level.SEVERE,"WebDebugMonitor.getDebugMonitoringDetails(), Exception when trying to get the System properties - ", e.toString());
        }
        return resultMap;
    }        
    
}
