/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.jsp;

import java.security.AccessController;
import java.security.PrivilegedAction;

import javax.servlet.ServletContext;
import javax.servlet.jsp.tagext.JspTag;

import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.StandardContext;
import org.apache.jasper.runtime.ResourceInjector;

import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.InjectionManager;

/**
 * SJSAS implementation of the org.apache.jasper.runtime.ResourceInjector
 * interface.
 *
 * @author Jan Luehe
 */
public class ResourceInjectorImpl implements ResourceInjector {

    private InjectionManager injectionMgr;
    private JndiNameEnvironment desc;

    /**
     * Constructor.
     */
    public ResourceInjectorImpl() {
        injectionMgr = Switch.getSwitch().getInjectionManager();
    }


    /**
     * Associates this ResourceInjector with the component environment of the
     * given servlet context.
     *
     * @param servletContext The servlet context 
     */
    public void setContext(ServletContext servletContext) {

        if (!(servletContext instanceof ApplicationContextFacade)) {
            return;
        }

        final ApplicationContextFacade contextFacade =
            (ApplicationContextFacade) servletContext;

        StandardContext context = null;

        if (System.getSecurityManager() != null) {
            context = (StandardContext) AccessController.doPrivileged(
                    new PrivilegedAction() {
                public Object run() {
                    return contextFacade.getUnwrappedContext();
                }
            });
        } else {
            context = contextFacade.getUnwrappedContext();
        }

        if (context != null) {
            desc = (JndiNameEnvironment)
                Switch.getSwitch().getDescriptorFor(context);
        }
    }

   
    /**
     * Injects the injectable resources from the component environment 
     * associated with this ResourceInjectorImpl into the given 
     * tag handler instance. 
     *
     * @param handler The tag handler instance to be injected
     *
     * @throws Exception if an error occurs during injection
     */
    public void inject(JspTag handler) throws Exception {

        if( desc != null ) {
            injectionMgr.injectInstance(handler, desc);
        }
    }

}
