/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceContext;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.Invoker;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.AsyncProviderCallback;
import com.sun.xml.ws.api.server.WSWebServiceContext;

/**
 * Implements JAXWS's Invoker interface to call the endpoint method
 */
public class InvokerImpl extends Invoker {
    protected Invoker core;
    protected Object invokeObject;
    protected WebServiceContextImpl injectedWSCtxt;

    public InvokerImpl(Invoker core, Object inv, WebServiceContextImpl wsc) {
        this.core = core;
        this.injectedWSCtxt = wsc;
        this.invokeObject = inv;
    }

    private static final boolean jaxwsDirect=Boolean.getBoolean("com.sun.enterprise.webservice.jaxwsDirect");

    public void start(WSWebServiceContext wsc, WSEndpoint endpoint) {
        if(this.injectedWSCtxt != null) {
            injectedWSCtxt.setContextDelegate(wsc);
        }
        core.start(injectedWSCtxt, endpoint);
    }

    public void dispose() {
        core.dispose();
    }

    public Object invoke(Packet p, Method m, Object... args) throws InvocationTargetException, IllegalAccessException {
        if(jaxwsDirect)
            return core.invoke(p,m,args);
        Object ret = null;
        if(this.invokeObject != null) {
            ret = m.invoke(this.invokeObject, args);
        }
        return ret;
    }

    public <T> T invokeProvider(Packet p, T arg) throws IllegalAccessException, InvocationTargetException {
        return core.invokeProvider(p, arg);
    }

    public <T> void invokeAsyncProvider(Packet p, T arg, AsyncProviderCallback cbak, WebServiceContext ctxt) throws IllegalAccessException, InvocationTargetException {
        core.invokeAsyncProvider(p, arg, cbak, ctxt);
    }
}
