/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import com.sun.xml.ws.api.server.Adapter;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Registry of JAXWS Adapter of endpoints.
 */
public class JAXWSAdapterRegistry {
    
    private static JAXWSAdapterRegistry registry = null;
    private Map store;
    private static StringManager localStrings =
        StringManager.getManager(JAXWSAdapterRegistry.class);
    Logger logger = LogDomains.getLogger(LogDomains.WEB_LOGGER);
    
    /** Creates a new instance of JAXWSServletUtil */
    private JAXWSAdapterRegistry() {
        store = new HashMap();
    }
    
    public static JAXWSAdapterRegistry getInstance() {
        if(registry == null)
            registry = new JAXWSAdapterRegistry();
        return registry;
    }
    
    public void addAdapter(String contextRoot, String urlPattern, 
            Adapter info) {
        if (contextRoot == null)
            contextRoot = "";
        ContextAdapter contextRtInfo = 
                (ContextAdapter)store.get(contextRoot);
        if(contextRtInfo == null) {
            contextRtInfo = new ContextAdapter(contextRoot);
        }        
        contextRtInfo.addAdapter(urlPattern, info);
        store.put(contextRoot, contextRtInfo);
    }
    
     public Adapter getAdapter(String contextRoot,
             String path, String urlPattern ) {
         ContextAdapter serviceInfo = 
                (ContextAdapter)store.get(contextRoot);        
        if(serviceInfo == null)
             return null;        
         return serviceInfo.getAdapter(path, urlPattern);
     }
  
     public void removeAdapter(String contextRoot) {
         if(contextRoot == null)
             contextRoot = "";
         ContextAdapter serviceInfo = 
                (ContextAdapter)store.get(contextRoot);
        if(serviceInfo == null)
             return ;
        store.remove(contextRoot);
     }
     
    class  ContextAdapter {
        String contextRoot;
        Map fixedUrlPatternEndpoints;
        List<Adapter> pathUrlPatternEndpoints;

        ContextAdapter(String contextRoot) {
            this.contextRoot = contextRoot;
            fixedUrlPatternEndpoints = new HashMap();
            pathUrlPatternEndpoints = new ArrayList();
        }

        void addAdapter(String urlPattern, Adapter info) {
            if (urlPattern.indexOf("*.") != -1) {
                // cannot deal with implicit mapping right now
                logger.log(Level.SEVERE, 
                        localStrings.getString("enterprise.webservice.implicitMappingNotSupported"));
            } else if (urlPattern.endsWith("/*")) {
                pathUrlPatternEndpoints.add(info);
            } else {
                if (fixedUrlPatternEndpoints.containsKey(urlPattern)) {
                    logger.log(Level.SEVERE, 
                            localStrings.getString("enterprise.webservice.duplicateService", 
                            new Object[]{urlPattern}));
                }
                fixedUrlPatternEndpoints.put(urlPattern, info);
            }
        }

        Adapter getAdapter(String path, String urlPattern) {
            Adapter result = (Adapter) fixedUrlPatternEndpoints.get(path);
            if (result == null) {                
                // This loop is unnecessary.Essentially what it is doing to always
                // return the first element from pathUrlPatternEndpoints
                // TO DO clean up after SCF required
                for (Iterator iter = pathUrlPatternEndpoints.iterator(); iter.hasNext();) {
                    Adapter candidate = (Adapter) iter.next();
                    if (path.startsWith(getValidPathForEndpoint(urlPattern))) {
                        result = candidate;
                        break;
                    }
                }
            }
            return result;
        }

         private String getValidPathForEndpoint(String s) {
            if (s.endsWith("/*")) {
                return s.substring(0, s.length() - 2);
            } else {
                return s;
            }
        }
    }
}
