/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice;

import java.util.Set;
import java.util.Iterator;
import java.util.logging.Level;

import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Binding;
import javax.xml.ws.soap.SOAPBinding;

import com.sun.xml.ws.api.client.ServiceInterceptor;
import com.sun.xml.ws.developer.WSBindingProvider;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.NameValuePairDescriptor;

/**
 * This is way port creation calls are going to be intercepted in JAXWS2.1
 */
public class PortCreationCallbackImpl extends ServiceInterceptor {

    private ServiceReferenceDescriptor ref;
    
    public PortCreationCallbackImpl(ServiceReferenceDescriptor svcRef) {
        ref = svcRef;
    }
    
    public void postCreateProxy(WSBindingProvider bp, Class<?> serviceEndpointInterface) {
        ServiceRefPortInfo portInfo = ref.getPortInfoBySEI(serviceEndpointInterface.getName());
        if (portInfo!=null) {          
            // Set MTOM for this port
            boolean mtomEnabled = false;
            if(portInfo.getMtomEnabled() != null &&
                (new Boolean(portInfo.getMtomEnabled())).booleanValue()) {
                mtomEnabled = true;
            }
            if (mtomEnabled) {
                Binding bType = bp.getBinding();
                // enable mtom valid only for SOAPBindings
                if(SOAPBinding.class.isAssignableFrom(bType.getClass())) {
                    ((SOAPBinding)bType).setMTOMEnabled(true);
                } else {
                    WsUtil.getDefaultLogger().log(Level.SEVERE,
                            WsUtil.getDefaultStringManager().getLocalString("serviceref.invalidmtom",
                            "MTOM is valid only for SOAP Bindings; Ignoring Enable-MTOM for port {0}",
                            new Object[] {serviceEndpointInterface}));
                }
            }
            
            // Set stub properties
            Set properties = portInfo.getStubProperties();            
            for(Iterator iter = properties.iterator(); iter.hasNext();) {
                NameValuePairDescriptor next = (NameValuePairDescriptor) 
                    iter.next();
                bp.getRequestContext().put(next.getName(), next.getValue());
            }
        }        
    }

    public void postCreateDispatch(WSBindingProvider bp) {}
}
