/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.util.Iterator;

import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;

import com.sun.xml.ws.api.server.ResourceInjector;
import com.sun.xml.ws.api.server.WSWebServiceContext;

import com.sun.enterprise.util.InjectionManagerImpl;

import com.sun.enterprise.InjectionException;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.Switch;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.ComponentInvocation;

/**
 * JAXWS Container call back to inject servlet endpoints
 */

public class ResourceInjectorImpl extends ResourceInjector {
    
    private WebServiceEndpoint endpoint;
    private ComponentInvocation inv;
    private InvocationManager invMgr;
    
    public ResourceInjectorImpl(WebServiceEndpoint ep) {
        // 
        Switch theSwitch = Switch.getSwitch();
        invMgr = theSwitch.getInvocationManager();
        inv = invMgr.getCurrentInvocation();
        //
        endpoint = ep;
    }
    
    public void inject(WSWebServiceContext context, Object instance) 
                    throws WebServiceException {

        try {
            // Set proper component context
            invMgr.preInvoke(inv);
            // Injection first
            new InjectionManagerImpl().injectInstance(instance);

            // Set webservice context here
            // If the endpoint has a WebServiceContext with @Resource then
            // that has to be used
            WebServiceContextImpl wsc = null;
            WebBundleDescriptor bundle = (WebBundleDescriptor)endpoint.getBundleDescriptor();
            Iterator<ResourceReferenceDescriptor> it = bundle.getResourceReferenceDescriptors().iterator();
            while(it.hasNext()) {
                ResourceReferenceDescriptor r = it.next();            
                if(r.isWebServiceContext()) {
                    Iterator<InjectionTarget> iter = r.getInjectionTargets().iterator();
                    boolean matchingClassFound = false;
                    while(iter.hasNext()) {
                        InjectionTarget target = iter.next();
                        if(endpoint.getServletImplClass().equals(target.getClassName())) {
                            matchingClassFound = true;
                            break;
                        }
                    }
                    if(!matchingClassFound) {
                        continue;
                    }
                    try {
                        javax.naming.InitialContext ic = new javax.naming.InitialContext();
                        wsc = (WebServiceContextImpl) ic.lookup("java:comp/env/" + r.getName());
                    } catch (Throwable t) {
                        // Do something here
                    }
                    if(wsc != null) {
                        wsc.setContextDelegate(context);
                    }
                }
            }
        } catch (InjectionException ie) {
            throw new WebServiceException(ie);
        } finally {
            invMgr.postInvoke(inv);
        }
    }
}
