/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.webservice;

import java.util.Set;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Collection;

import javax.xml.namespace.QName;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.MessageContext.Scope;

import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.message.saaj.SAAJMessage;

import com.sun.enterprise.webservice.SOAPMessageContext;
import java.util.jar.Pack200;

import javax.xml.soap.SOAPMessage;

/**
 * Implementation of SOAPMessageContext
 */
public class SOAPMessageContextImpl implements SOAPMessageContext {

    private Packet packet = null;

    public SOAPMessageContextImpl(Packet pkt) {
        this.packet = pkt;
    }

    public SOAPMessage getMessage() {
        SOAPMessage soapMsg = null;
        try {
            soapMsg = packet.getMessage().readAsSOAPMessage();
            setMessage(soapMsg);
        } catch (Exception e) {
            e.printStackTrace();
        }
        // We do this here because the SOAP Body in Packet can be read only once
        // To enable subsequent pipe stages read soap messages we do this here
        return soapMsg;
    }

    public void setMessage(SOAPMessage newMsg) {
        try {
            packet.setMessage(Messages.create(newMsg));
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    public Object[] getHeaders(QName header, JAXBContext jaxbContext, boolean allRoles) {
        // this is a dummy impl; we do not use it at all
        return null;
    }

    public Set<String> getRoles() {
        // this is a dummy impl; we do not use it at all
        return null;
    }

    public Scope getScope(String name) {
        // this is a dummy impl; we do not use it at all
        return null;
    }

    public void setScope(String name, Scope scope) {
        // this is a dummy impl; we do not use it at all
        return;
    }

    public boolean isAlreadySoap() {
        // In jaxws-rearch, only SOAP messages come here
        // So always return true
        return true;
    }
    
    /* java.util.Map methods below here */

    public void clear() {
        // We just clear whatever we set; we do not clear jaxws's properties'
        packet.invocationProperties.clear();
    }

    public boolean containsKey(Object obj) {
        // First check our property bag
        if(packet.supports(obj)) {
            return packet.containsKey(obj);
        }
        return packet.invocationProperties.containsKey(obj);
    }

    public boolean containsValue(Object obj) {
        return packet.invocationProperties.containsValue(obj);
    }

    public Set<Entry<String, Object>> entrySet() {
        return packet.invocationProperties.entrySet();
    }

    public Object get(Object obj) {
        if(packet.supports(obj)) {
            return packet.get(obj);
        }
        return packet.invocationProperties.get(obj);
    }

    public boolean isEmpty() {
        return packet.invocationProperties.isEmpty();
    }

    public Set<String> keySet() {
        return packet.invocationProperties.keySet();
    }

    public Object put(String str, Object obj) {
        return packet.invocationProperties.put(str, obj);
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        packet.invocationProperties.putAll(map);
    }

    public Object remove(Object obj) {
        return packet.invocationProperties.remove(obj);
    }

    public int size() {
        return packet.invocationProperties.size();
    }

    public Collection<Object> values() {
        return packet.invocationProperties.values();
    }
}
