/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PrincipalGroupFactory.java
 *
 * Created on October 28, 2004, 12:34 PM
 */

package com.sun.web.security;

import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.deployment.Group;
import com.sun.web.security.WebSecurityManager;
/**
 *
 * @author  Harpreet Singh
 */
public class PrincipalGroupFactory {
    
    /** Creates a new instance of PrincipalGroupFactory */

    public static PrincipalImpl getPrincipalInstance(String name, String realm){
        PrincipalImpl p = (PrincipalImpl)WebSecurityManager.getAdminPrincipal(name, realm) ;
        if(p == null){
            p = new PrincipalImpl(name);
        }
        return p;
    }
    
    public static Group getGroupInstance(String name, String realm){
        Group g = (Group)WebSecurityManager.getAdminGroup(name, realm);
        if(g == null){
            g = new Group(name);
        }
        return g;
    }
}
