/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.grizzly.rails.standalone;

import java.io.IOException;

import com.sun.grizzly.rails.RailsSelectorThread;

public class Main {
    public static void main(String[] args) throws IOException, InstantiationException {
        String railsRoot = null;

        if (args.length > 0) {
            railsRoot = args[0];
        } else {
            System.err.println("Usage: java com.sun.grizzly.rails.standalone.Main RAILS_ROOT");
            System.exit(1);
        }

        RailsSelectorThread selectorThread = new RailsSelectorThread();
        selectorThread.setRailsRoot(railsRoot);
        selectorThread.setPort(8080);
//        selectorThread.setNumberOfRuntime(3);
        selectorThread.setNumberOfRuntime(1);
        selectorThread.setDisplayConfiguration(true);
        selectorThread.initEndpoint();
        selectorThread.startEndpoint();
    }
}
